package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaClusterSpecBuilder extends KafkaClusterSpecFluent<KafkaClusterSpecBuilder> implements VisitableBuilder<KafkaClusterSpec,KafkaClusterSpecBuilder>{
  public KafkaClusterSpecBuilder() {
    this(false);
  }
  public KafkaClusterSpecBuilder(Boolean validationEnabled) {
    this(new KafkaClusterSpec(), validationEnabled);
  }
  public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaClusterSpec(), validationEnabled);
  }
  public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent,KafkaClusterSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent,KafkaClusterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaClusterSpec());

    if (instance != null) {
      fluent.withStorage(instance.getStorage());
      fluent.withVersion(instance.getVersion());
      fluent.withMetadataVersion(instance.getMetadataVersion());
      fluent.withConfig(instance.getConfig());
      fluent.withBrokerRackInitImage(instance.getBrokerRackInitImage());
      fluent.withRack(instance.getRack());
      fluent.withLogging(instance.getLogging());
      fluent.withReplicas(instance.getReplicas());
      fluent.withImage(instance.getImage());
      fluent.withResources(instance.getResources());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withJmxOptions(instance.getJmxOptions());
      fluent.withMetricsConfig(instance.getMetricsConfig());
      fluent.withListeners(instance.getListeners());
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withTemplate(instance.getTemplate());
      fluent.withTieredStorage(instance.getTieredStorage());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaClusterSpecBuilder(KafkaClusterSpec instance) {
    this(instance,false);
  }
  public KafkaClusterSpecBuilder(KafkaClusterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaClusterSpec());

    if (instance != null) {
      this.withStorage(instance.getStorage());
      this.withVersion(instance.getVersion());
      this.withMetadataVersion(instance.getMetadataVersion());
      this.withConfig(instance.getConfig());
      this.withBrokerRackInitImage(instance.getBrokerRackInitImage());
      this.withRack(instance.getRack());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJvmOptions(instance.getJvmOptions());
      this.withJmxOptions(instance.getJmxOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withListeners(instance.getListeners());
      this.withAuthorization(instance.getAuthorization());
      this.withTemplate(instance.getTemplate());
      this.withTieredStorage(instance.getTieredStorage());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaClusterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaClusterSpec build() {
    KafkaClusterSpec buildable = new KafkaClusterSpec();
    buildable.setStorage(fluent.buildStorage());
    buildable.setVersion(fluent.getVersion());
    buildable.setMetadataVersion(fluent.getMetadataVersion());
    buildable.setConfig(fluent.getConfig());
    buildable.setBrokerRackInitImage(fluent.getBrokerRackInitImage());
    buildable.setRack(fluent.buildRack());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setListeners(fluent.buildListeners());
    buildable.setAuthorization(fluent.buildAuthorization());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setTieredStorage(fluent.buildTieredStorage());
    return buildable;
  }
  
}