package io.strimzi.api.kafka.model.kafka;

import io.strimzi.api.kafka.model.common.RackBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.kafka.tieredstorage.TieredStorageCustomBuilder;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.kafka.tieredstorage.TieredStorageCustom;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import java.lang.Object;
import java.util.Map;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.kafka.tieredstorage.TieredStorageCustomFluent;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListener;
import java.util.List;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.RackFluent;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsFluent;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.kafka.tieredstorage.TieredStorage;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerFluent;
import io.strimzi.api.kafka.model.common.JvmOptions;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.common.Rack;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import java.util.Iterator;
import java.lang.Integer;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptions;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaClusterSpecFluent<A extends KafkaClusterSpecFluent<A>> extends BaseFluent<A>{
  public KafkaClusterSpecFluent() {
  }
  public KafkaClusterSpecFluent(KafkaClusterSpec instance) {
    instance = (instance != null ? instance : new KafkaClusterSpec());

    if (instance != null) {
      this.withStorage(instance.getStorage());
      this.withVersion(instance.getVersion());
      this.withMetadataVersion(instance.getMetadataVersion());
      this.withConfig(instance.getConfig());
      this.withBrokerRackInitImage(instance.getBrokerRackInitImage());
      this.withRack(instance.getRack());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJvmOptions(instance.getJvmOptions());
      this.withJmxOptions(instance.getJmxOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withListeners(instance.getListeners());
      this.withAuthorization(instance.getAuthorization());
      this.withTemplate(instance.getTemplate());
      this.withTieredStorage(instance.getTieredStorage());
    }
  }
  private VisitableBuilder<? extends Storage,?> storage;
  private String version;
  private String metadataVersion;
  private Map<String,Object> config;
  private String brokerRackInitImage;
  private RackBuilder rack;
  private VisitableBuilder<? extends Logging,?> logging;
  private Integer replicas;
  private String image;
  private ResourceRequirements resources;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private JvmOptionsBuilder jvmOptions;
  private KafkaJmxOptionsBuilder jmxOptions;
  private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
  private ArrayList<GenericKafkaListenerBuilder> listeners;
  private VisitableBuilder<? extends KafkaAuthorization,?> authorization;
  private KafkaClusterTemplateBuilder template;
  private VisitableBuilder<? extends TieredStorage,?> tieredStorage;
  public Storage buildStorage() {
    return this.storage!=null?this.storage.build():null;
  }
  public A withStorage(Storage storage) {
    if (storage==null){ this.storage = null; _visitables.remove("storage"); return (A) this;}
    VisitableBuilder<? extends Storage,?> builder = builder(storage); _visitables.get("storage").clear();_visitables.get("storage").add(builder);this.storage = builder;
    return (A) this;
  }
  public boolean hasStorage() {
    return this.storage != null;
  }
  public EphemeralStorageNested<A> withNewEphemeralStorage() {
    return new EphemeralStorageNested(null);
  }
  public EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
    return new EphemeralStorageNested(item);
  }
  public PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
    return new PersistentClaimStorageNested(null);
  }
  public PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
    return new PersistentClaimStorageNested(item);
  }
  public JbodStorageNested<A> withNewJbodStorage() {
    return new JbodStorageNested(null);
  }
  public JbodStorageNested<A> withNewJbodStorageLike(JbodStorage item) {
    return new JbodStorageNested(item);
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public boolean hasVersion() {
    return this.version != null;
  }
  public String getMetadataVersion() {
    return this.metadataVersion;
  }
  public A withMetadataVersion(String metadataVersion) {
    this.metadataVersion=metadataVersion; return (A) this;
  }
  public boolean hasMetadataVersion() {
    return this.metadataVersion != null;
  }
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getConfig() {
    return this.config;
  }
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap(config);} return (A) this;
  }
  public boolean hasConfig() {
    return this.config != null;
  }
  public String getBrokerRackInitImage() {
    return this.brokerRackInitImage;
  }
  public A withBrokerRackInitImage(String brokerRackInitImage) {
    this.brokerRackInitImage=brokerRackInitImage; return (A) this;
  }
  public boolean hasBrokerRackInitImage() {
    return this.brokerRackInitImage != null;
  }
  public Rack buildRack() {
    return this.rack!=null ?this.rack.build():null;
  }
  public A withRack(Rack rack) {
    _visitables.get("rack").remove(this.rack);
    if (rack!=null){ this.rack= new RackBuilder(rack); _visitables.get("rack").add(this.rack);} else { this.rack = null; _visitables.get("rack").remove(this.rack); } return (A) this;
  }
  public boolean hasRack() {
    return this.rack != null;
  }
  public A withNewRack(String topologyKey) {
    return (A)withRack(new Rack(topologyKey));
  }
  public RackNested<A> withNewRack() {
    return new RackNested(null);
  }
  public RackNested<A> withNewRackLike(Rack item) {
    return new RackNested(item);
  }
  public RackNested<A> editRack() {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(null));
  }
  public RackNested<A> editOrNewRack() {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(new RackBuilder().build()));
  }
  public RackNested<A> editOrNewRackLike(Rack item) {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(item));
  }
  public Logging buildLogging() {
    return this.logging!=null?this.logging.build():null;
  }
  public A withLogging(Logging logging) {
    if (logging==null){ this.logging = null; _visitables.remove("logging"); return (A) this;}
    VisitableBuilder<? extends Logging,?> builder = builder(logging); _visitables.get("logging").clear();_visitables.get("logging").add(builder);this.logging = builder;
    return (A) this;
  }
  public boolean hasLogging() {
    return this.logging != null;
  }
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public Probe buildLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public A withLivenessProbe(Probe livenessProbe) {
    _visitables.get("livenessProbe").remove(this.livenessProbe);
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} else { this.livenessProbe = null; _visitables.get("livenessProbe").remove(this.livenessProbe); } return (A) this;
  }
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  public Probe buildReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public A withReadinessProbe(Probe readinessProbe) {
    _visitables.get("readinessProbe").remove(this.readinessProbe);
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} else { this.readinessProbe = null; _visitables.get("readinessProbe").remove(this.readinessProbe); } return (A) this;
  }
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions!=null ?this.jvmOptions.build():null;
  }
  public A withJvmOptions(JvmOptions jvmOptions) {
    _visitables.get("jvmOptions").remove(this.jvmOptions);
    if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} else { this.jvmOptions = null; _visitables.get("jvmOptions").remove(this.jvmOptions); } return (A) this;
  }
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  public KafkaJmxOptions buildJmxOptions() {
    return this.jmxOptions!=null ?this.jmxOptions.build():null;
  }
  public A withJmxOptions(KafkaJmxOptions jmxOptions) {
    _visitables.get("jmxOptions").remove(this.jmxOptions);
    if (jmxOptions!=null){ this.jmxOptions= new KafkaJmxOptionsBuilder(jmxOptions); _visitables.get("jmxOptions").add(this.jmxOptions);} else { this.jmxOptions = null; _visitables.get("jmxOptions").remove(this.jmxOptions); } return (A) this;
  }
  public boolean hasJmxOptions() {
    return this.jmxOptions != null;
  }
  public JmxOptionsNested<A> withNewJmxOptions() {
    return new JmxOptionsNested(null);
  }
  public JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item) {
    return new JmxOptionsNested(item);
  }
  public JmxOptionsNested<A> editJmxOptions() {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(null));
  }
  public JmxOptionsNested<A> editOrNewJmxOptions() {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(new KafkaJmxOptionsBuilder().build()));
  }
  public JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item) {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(item));
  }
  public MetricsConfig buildMetricsConfig() {
    return this.metricsConfig!=null?this.metricsConfig.build():null;
  }
  public A withMetricsConfig(MetricsConfig metricsConfig) {
    if (metricsConfig==null){ this.metricsConfig = null; _visitables.remove("metricsConfig"); return (A) this;}
    VisitableBuilder<? extends MetricsConfig,?> builder = builder(metricsConfig); _visitables.get("metricsConfig").clear();_visitables.get("metricsConfig").add(builder);this.metricsConfig = builder;
    return (A) this;
  }
  public boolean hasMetricsConfig() {
    return this.metricsConfig != null;
  }
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
    return new JmxPrometheusExporterMetricsConfigNested(null);
  }
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
    return new JmxPrometheusExporterMetricsConfigNested(item);
  }
  public A addToListeners(int index,GenericKafkaListener item) {
    if (this.listeners == null) {this.listeners = new ArrayList<GenericKafkaListenerBuilder>();}
    GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
    if (index < 0 || index >= listeners.size()) { _visitables.get("listeners").add(builder); listeners.add(builder); } else { _visitables.get("listeners").add(index, builder); listeners.add(index, builder);}
    return (A)this;
  }
  public A setToListeners(int index,GenericKafkaListener item) {
    if (this.listeners == null) {this.listeners = new ArrayList<GenericKafkaListenerBuilder>();}
    GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
    if (index < 0 || index >= listeners.size()) { _visitables.get("listeners").add(builder); listeners.add(builder); } else { _visitables.get("listeners").set(index, builder); listeners.set(index, builder);}
    return (A)this;
  }
  public A addToListeners(io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListener... items) {
    if (this.listeners == null) {this.listeners = new ArrayList<GenericKafkaListenerBuilder>();}
    for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
  }
  public A addAllToListeners(Collection<GenericKafkaListener> items) {
    if (this.listeners == null) {this.listeners = new ArrayList<GenericKafkaListenerBuilder>();}
    for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
  }
  public A removeFromListeners(io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListener... items) {
    if (this.listeners == null) return (A)this;
    for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("listeners").remove(builder); this.listeners.remove(builder);} return (A)this;
  }
  public A removeAllFromListeners(Collection<GenericKafkaListener> items) {
    if (this.listeners == null) return (A)this;
    for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("listeners").remove(builder); this.listeners.remove(builder);} return (A)this;
  }
  public A removeMatchingFromListeners(Predicate<GenericKafkaListenerBuilder> predicate) {
    if (listeners == null) return (A) this;
    final Iterator<GenericKafkaListenerBuilder> each = listeners.iterator();
    final List visitables = _visitables.get("listeners");
    while (each.hasNext()) {
      GenericKafkaListenerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GenericKafkaListener> buildListeners() {
    return listeners != null ? build(listeners) : null;
  }
  public GenericKafkaListener buildListener(int index) {
    return this.listeners.get(index).build();
  }
  public GenericKafkaListener buildFirstListener() {
    return this.listeners.get(0).build();
  }
  public GenericKafkaListener buildLastListener() {
    return this.listeners.get(listeners.size() - 1).build();
  }
  public GenericKafkaListener buildMatchingListener(Predicate<GenericKafkaListenerBuilder> predicate) {
    for (GenericKafkaListenerBuilder item: listeners) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingListener(Predicate<GenericKafkaListenerBuilder> predicate) {
    for (GenericKafkaListenerBuilder item: listeners) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withListeners(List<GenericKafkaListener> listeners) {
    if (this.listeners != null) { _visitables.get("listeners").clear();}
    if (listeners != null) {this.listeners = new ArrayList(); for (GenericKafkaListener item : listeners){this.addToListeners(item);}} else { this.listeners = null;} return (A) this;
  }
  public A withListeners(io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListener... listeners) {
    if (this.listeners != null) {this.listeners.clear(); _visitables.remove("listeners"); }
    if (listeners != null) {for (GenericKafkaListener item :listeners){ this.addToListeners(item);}} return (A) this;
  }
  public boolean hasListeners() {
    return listeners != null && !listeners.isEmpty();
  }
  public ListenersNested<A> addNewListener() {
    return new ListenersNested(-1, null);
  }
  public ListenersNested<A> addNewListenerLike(GenericKafkaListener item) {
    return new ListenersNested(-1, item);
  }
  public ListenersNested<A> setNewListenerLike(int index,GenericKafkaListener item) {
    return new ListenersNested(index, item);
  }
  public ListenersNested<A> editListener(int index) {
    if (listeners.size() <= index) throw new RuntimeException("Can't edit listeners. Index exceeds size.");
    return setNewListenerLike(index, buildListener(index));
  }
  public ListenersNested<A> editFirstListener() {
    if (listeners.size() == 0) throw new RuntimeException("Can't edit first listeners. The list is empty.");
    return setNewListenerLike(0, buildListener(0));
  }
  public ListenersNested<A> editLastListener() {
    int index = listeners.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last listeners. The list is empty.");
    return setNewListenerLike(index, buildListener(index));
  }
  public ListenersNested<A> editMatchingListener(Predicate<GenericKafkaListenerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<listeners.size();i++) { 
    if (predicate.test(listeners.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching listeners. No match found.");
    return setNewListenerLike(index, buildListener(index));
  }
  public KafkaAuthorization buildAuthorization() {
    return this.authorization!=null?this.authorization.build():null;
  }
  public A withAuthorization(KafkaAuthorization authorization) {
    if (authorization==null){ this.authorization = null; _visitables.remove("authorization"); return (A) this;}
    VisitableBuilder<? extends KafkaAuthorization,?> builder = builder(authorization); _visitables.get("authorization").clear();_visitables.get("authorization").add(builder);this.authorization = builder;
    return (A) this;
  }
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  public KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimple() {
    return new KafkaAuthorizationSimpleNested(null);
  }
  public KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimpleLike(KafkaAuthorizationSimple item) {
    return new KafkaAuthorizationSimpleNested(item);
  }
  public KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustom() {
    return new KafkaAuthorizationCustomNested(null);
  }
  public KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustomLike(KafkaAuthorizationCustom item) {
    return new KafkaAuthorizationCustomNested(item);
  }
  public KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpa() {
    return new KafkaAuthorizationOpaNested(null);
  }
  public KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpaLike(KafkaAuthorizationOpa item) {
    return new KafkaAuthorizationOpaNested(item);
  }
  public KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloak() {
    return new KafkaAuthorizationKeycloakNested(null);
  }
  public KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloakLike(KafkaAuthorizationKeycloak item) {
    return new KafkaAuthorizationKeycloakNested(item);
  }
  public KafkaClusterTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(KafkaClusterTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new KafkaClusterTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(KafkaClusterTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new KafkaClusterTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(KafkaClusterTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public TieredStorage buildTieredStorage() {
    return this.tieredStorage!=null?this.tieredStorage.build():null;
  }
  public A withTieredStorage(TieredStorage tieredStorage) {
    if (tieredStorage==null){ this.tieredStorage = null; _visitables.remove("tieredStorage"); return (A) this;}
    VisitableBuilder<? extends TieredStorage,?> builder = builder(tieredStorage); _visitables.get("tieredStorage").clear();_visitables.get("tieredStorage").add(builder);this.tieredStorage = builder;
    return (A) this;
  }
  public boolean hasTieredStorage() {
    return this.tieredStorage != null;
  }
  public TieredStorageCustomTieredNested<A> withNewTieredStorageCustomTiered() {
    return new TieredStorageCustomTieredNested(null);
  }
  public TieredStorageCustomTieredNested<A> withNewTieredStorageCustomTieredLike(TieredStorageCustom item) {
    return new TieredStorageCustomTieredNested(item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaClusterSpecFluent that = (KafkaClusterSpecFluent) o;
    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(metadataVersion, that.metadataVersion)) return false;

    if (!java.util.Objects.equals(config, that.config)) return false;

    if (!java.util.Objects.equals(brokerRackInitImage, that.brokerRackInitImage)) return false;

    if (!java.util.Objects.equals(rack, that.rack)) return false;

    if (!java.util.Objects.equals(logging, that.logging)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;

    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;

    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;

    if (!java.util.Objects.equals(jmxOptions, that.jmxOptions)) return false;

    if (!java.util.Objects.equals(metricsConfig, that.metricsConfig)) return false;

    if (!java.util.Objects.equals(listeners, that.listeners)) return false;

    if (!java.util.Objects.equals(authorization, that.authorization)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    if (!java.util.Objects.equals(tieredStorage, that.tieredStorage)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(storage,  version,  metadataVersion,  config,  brokerRackInitImage,  rack,  logging,  replicas,  image,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  jmxOptions,  metricsConfig,  listeners,  authorization,  template,  tieredStorage,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (metadataVersion != null) { sb.append("metadataVersion:"); sb.append(metadataVersion + ","); }
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config + ","); }
    if (brokerRackInitImage != null) { sb.append("brokerRackInitImage:"); sb.append(brokerRackInitImage + ","); }
    if (rack != null) { sb.append("rack:"); sb.append(rack + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions + ","); }
    if (jmxOptions != null) { sb.append("jmxOptions:"); sb.append(jmxOptions + ","); }
    if (metricsConfig != null) { sb.append("metricsConfig:"); sb.append(metricsConfig + ","); }
    if (listeners != null && !listeners.isEmpty()) { sb.append("listeners:"); sb.append(listeners + ","); }
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (tieredStorage != null) { sb.append("tieredStorage:"); sb.append(tieredStorage); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.kafka."+"EphemeralStorage": return (VisitableBuilder<T, ?>)new EphemeralStorageBuilder((EphemeralStorage) item);
    case "io.strimzi.api.kafka.model.kafka."+"PersistentClaimStorage": return (VisitableBuilder<T, ?>)new PersistentClaimStorageBuilder((PersistentClaimStorage) item);
    case "io.strimzi.api.kafka.model.kafka."+"JbodStorage": return (VisitableBuilder<T, ?>)new JbodStorageBuilder((JbodStorage) item);
    case "io.strimzi.api.kafka.model.common."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    case "io.strimzi.api.kafka.model.common."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    case "io.strimzi.api.kafka.model.common.metrics."+"JmxPrometheusExporterMetrics": return (VisitableBuilder<T, ?>)new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics) item);
    case "io.strimzi.api.kafka.model.kafka."+"KafkaAuthorizationSimple": return (VisitableBuilder<T, ?>)new KafkaAuthorizationSimpleBuilder((KafkaAuthorizationSimple) item);
    case "io.strimzi.api.kafka.model.kafka."+"KafkaAuthorizationCustom": return (VisitableBuilder<T, ?>)new KafkaAuthorizationCustomBuilder((KafkaAuthorizationCustom) item);
    case "io.strimzi.api.kafka.model.kafka."+"KafkaAuthorizationOpa": return (VisitableBuilder<T, ?>)new KafkaAuthorizationOpaBuilder((KafkaAuthorizationOpa) item);
    case "io.strimzi.api.kafka.model.kafka."+"KafkaAuthorizationKeycloak": return (VisitableBuilder<T, ?>)new KafkaAuthorizationKeycloakBuilder((KafkaAuthorizationKeycloak) item);
    case "io.strimzi.api.kafka.model.kafka.tieredstorage."+"TieredStorageCustom": return (VisitableBuilder<T, ?>)new TieredStorageCustomBuilder((TieredStorageCustom) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class EphemeralStorageNested<N> extends EphemeralStorageFluent<EphemeralStorageNested<N>> implements Nested<N>{
    EphemeralStorageNested(EphemeralStorage item) {
      this.builder = new EphemeralStorageBuilder(this, item);
    }
    EphemeralStorageBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withStorage(builder.build());
    }
    public N endEphemeralStorage() {
      return and();
    }
    
  }
  public class PersistentClaimStorageNested<N> extends PersistentClaimStorageFluent<PersistentClaimStorageNested<N>> implements Nested<N>{
    PersistentClaimStorageNested(PersistentClaimStorage item) {
      this.builder = new PersistentClaimStorageBuilder(this, item);
    }
    PersistentClaimStorageBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withStorage(builder.build());
    }
    public N endPersistentClaimStorage() {
      return and();
    }
    
  }
  public class JbodStorageNested<N> extends JbodStorageFluent<JbodStorageNested<N>> implements Nested<N>{
    JbodStorageNested(JbodStorage item) {
      this.builder = new JbodStorageBuilder(this, item);
    }
    JbodStorageBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withStorage(builder.build());
    }
    public N endJbodStorage() {
      return and();
    }
    
  }
  public class RackNested<N> extends RackFluent<RackNested<N>> implements Nested<N>{
    RackNested(Rack item) {
      this.builder = new RackBuilder(this, item);
    }
    RackBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withRack(builder.build());
    }
    public N endRack() {
      return and();
    }
    
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withLogging(builder.build());
    }
    public N endInlineLogging() {
      return and();
    }
    
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withLogging(builder.build());
    }
    public N endExternalLogging() {
      return and();
    }
    
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe() {
      return and();
    }
    
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe() {
      return and();
    }
    
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions() {
      return and();
    }
    
  }
  public class JmxOptionsNested<N> extends KafkaJmxOptionsFluent<JmxOptionsNested<N>> implements Nested<N>{
    JmxOptionsNested(KafkaJmxOptions item) {
      this.builder = new KafkaJmxOptionsBuilder(this, item);
    }
    KafkaJmxOptionsBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withJmxOptions(builder.build());
    }
    public N endJmxOptions() {
      return and();
    }
    
  }
  public class JmxPrometheusExporterMetricsConfigNested<N> extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>> implements Nested<N>{
    JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
      this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
    }
    JmxPrometheusExporterMetricsBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withMetricsConfig(builder.build());
    }
    public N endJmxPrometheusExporterMetricsConfig() {
      return and();
    }
    
  }
  public class ListenersNested<N> extends GenericKafkaListenerFluent<ListenersNested<N>> implements Nested<N>{
    ListenersNested(int index,GenericKafkaListener item) {
      this.index = index;
      this.builder = new GenericKafkaListenerBuilder(this, item);
    }
    GenericKafkaListenerBuilder builder;
    int index;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.setToListeners(index,builder.build());
    }
    public N endListener() {
      return and();
    }
    
  }
  public class KafkaAuthorizationSimpleNested<N> extends KafkaAuthorizationSimpleFluent<KafkaAuthorizationSimpleNested<N>> implements Nested<N>{
    KafkaAuthorizationSimpleNested(KafkaAuthorizationSimple item) {
      this.builder = new KafkaAuthorizationSimpleBuilder(this, item);
    }
    KafkaAuthorizationSimpleBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withAuthorization(builder.build());
    }
    public N endKafkaAuthorizationSimple() {
      return and();
    }
    
  }
  public class KafkaAuthorizationCustomNested<N> extends KafkaAuthorizationCustomFluent<KafkaAuthorizationCustomNested<N>> implements Nested<N>{
    KafkaAuthorizationCustomNested(KafkaAuthorizationCustom item) {
      this.builder = new KafkaAuthorizationCustomBuilder(this, item);
    }
    KafkaAuthorizationCustomBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withAuthorization(builder.build());
    }
    public N endKafkaAuthorizationCustom() {
      return and();
    }
    
  }
  public class KafkaAuthorizationOpaNested<N> extends KafkaAuthorizationOpaFluent<KafkaAuthorizationOpaNested<N>> implements Nested<N>{
    KafkaAuthorizationOpaNested(KafkaAuthorizationOpa item) {
      this.builder = new KafkaAuthorizationOpaBuilder(this, item);
    }
    KafkaAuthorizationOpaBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withAuthorization(builder.build());
    }
    public N endKafkaAuthorizationOpa() {
      return and();
    }
    
  }
  public class KafkaAuthorizationKeycloakNested<N> extends KafkaAuthorizationKeycloakFluent<KafkaAuthorizationKeycloakNested<N>> implements Nested<N>{
    KafkaAuthorizationKeycloakNested(KafkaAuthorizationKeycloak item) {
      this.builder = new KafkaAuthorizationKeycloakBuilder(this, item);
    }
    KafkaAuthorizationKeycloakBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withAuthorization(builder.build());
    }
    public N endKafkaAuthorizationKeycloak() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends KafkaClusterTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(KafkaClusterTemplate item) {
      this.builder = new KafkaClusterTemplateBuilder(this, item);
    }
    KafkaClusterTemplateBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  public class TieredStorageCustomTieredNested<N> extends TieredStorageCustomFluent<TieredStorageCustomTieredNested<N>> implements Nested<N>{
    TieredStorageCustomTieredNested(TieredStorageCustom item) {
      this.builder = new TieredStorageCustomBuilder(this, item);
    }
    TieredStorageCustomBuilder builder;
    public N and() {
      return (N) KafkaClusterSpecFluent.this.withTieredStorage(builder.build());
    }
    public N endTieredStorageCustomTiered() {
      return and();
    }
    
  }
  
}