package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaClusterTemplateBuilder extends KafkaClusterTemplateFluent<KafkaClusterTemplateBuilder> implements VisitableBuilder<KafkaClusterTemplate,KafkaClusterTemplateBuilder>{
  public KafkaClusterTemplateBuilder() {
    this(false);
  }
  public KafkaClusterTemplateBuilder(Boolean validationEnabled) {
    this(new KafkaClusterTemplate(), validationEnabled);
  }
  public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaClusterTemplate(), validationEnabled);
  }
  public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent,KafkaClusterTemplate instance) {
    this(fluent, instance, false);
  }
  public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent,KafkaClusterTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaClusterTemplate());

    if (instance != null) {
      fluent.withStatefulset(instance.getStatefulset());
      fluent.withPodSet(instance.getPodSet());
      fluent.withPod(instance.getPod());
      fluent.withBootstrapService(instance.getBootstrapService());
      fluent.withBrokersService(instance.getBrokersService());
      fluent.withExternalBootstrapService(instance.getExternalBootstrapService());
      fluent.withPerPodService(instance.getPerPodService());
      fluent.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
      fluent.withPerPodRoute(instance.getPerPodRoute());
      fluent.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
      fluent.withPerPodIngress(instance.getPerPodIngress());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withClusterCaCert(instance.getClusterCaCert());
      fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      fluent.withKafkaContainer(instance.getKafkaContainer());
      fluent.withInitContainer(instance.getInitContainer());
      fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaClusterTemplateBuilder(KafkaClusterTemplate instance) {
    this(instance,false);
  }
  public KafkaClusterTemplateBuilder(KafkaClusterTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaClusterTemplate());

    if (instance != null) {
      this.withStatefulset(instance.getStatefulset());
      this.withPodSet(instance.getPodSet());
      this.withPod(instance.getPod());
      this.withBootstrapService(instance.getBootstrapService());
      this.withBrokersService(instance.getBrokersService());
      this.withExternalBootstrapService(instance.getExternalBootstrapService());
      this.withPerPodService(instance.getPerPodService());
      this.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
      this.withPerPodRoute(instance.getPerPodRoute());
      this.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
      this.withPerPodIngress(instance.getPerPodIngress());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withClusterCaCert(instance.getClusterCaCert());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withKafkaContainer(instance.getKafkaContainer());
      this.withInitContainer(instance.getInitContainer());
      this.withClusterRoleBinding(instance.getClusterRoleBinding());
      this.withServiceAccount(instance.getServiceAccount());
      this.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaClusterTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaClusterTemplate build() {
    KafkaClusterTemplate buildable = new KafkaClusterTemplate();
    buildable.setStatefulset(fluent.buildStatefulset());
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setBootstrapService(fluent.buildBootstrapService());
    buildable.setBrokersService(fluent.buildBrokersService());
    buildable.setExternalBootstrapService(fluent.buildExternalBootstrapService());
    buildable.setPerPodService(fluent.buildPerPodService());
    buildable.setExternalBootstrapRoute(fluent.buildExternalBootstrapRoute());
    buildable.setPerPodRoute(fluent.buildPerPodRoute());
    buildable.setExternalBootstrapIngress(fluent.buildExternalBootstrapIngress());
    buildable.setPerPodIngress(fluent.buildPerPodIngress());
    buildable.setPersistentVolumeClaim(fluent.buildPersistentVolumeClaim());
    buildable.setClusterCaCert(fluent.buildClusterCaCert());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setKafkaContainer(fluent.buildKafkaContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    buildable.setClusterRoleBinding(fluent.buildClusterRoleBinding());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  
}