package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaStatusBuilder extends KafkaStatusFluent<KafkaStatusBuilder> implements VisitableBuilder<KafkaStatus,KafkaStatusBuilder>{
  public KafkaStatusBuilder() {
    this(false);
  }
  public KafkaStatusBuilder(Boolean validationEnabled) {
    this(new KafkaStatus(), validationEnabled);
  }
  public KafkaStatusBuilder(KafkaStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaStatusBuilder(KafkaStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaStatus(), validationEnabled);
  }
  public KafkaStatusBuilder(KafkaStatusFluent<?> fluent,KafkaStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaStatusBuilder(KafkaStatusFluent<?> fluent,KafkaStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaStatus());

    if (instance != null) {
      fluent.withListeners(instance.getListeners());
      fluent.withKafkaNodePools(instance.getKafkaNodePools());
      fluent.withClusterId(instance.getClusterId());
      fluent.withOperatorLastSuccessfulVersion(instance.getOperatorLastSuccessfulVersion());
      fluent.withKafkaVersion(instance.getKafkaVersion());
      fluent.withKafkaMetadataVersion(instance.getKafkaMetadataVersion());
      fluent.withKafkaMetadataState(instance.getKafkaMetadataState());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaStatusBuilder(KafkaStatus instance) {
    this(instance,false);
  }
  public KafkaStatusBuilder(KafkaStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaStatus());

    if (instance != null) {
      this.withListeners(instance.getListeners());
      this.withKafkaNodePools(instance.getKafkaNodePools());
      this.withClusterId(instance.getClusterId());
      this.withOperatorLastSuccessfulVersion(instance.getOperatorLastSuccessfulVersion());
      this.withKafkaVersion(instance.getKafkaVersion());
      this.withKafkaMetadataVersion(instance.getKafkaMetadataVersion());
      this.withKafkaMetadataState(instance.getKafkaMetadataState());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaStatus build() {
    KafkaStatus buildable = new KafkaStatus();
    buildable.setListeners(fluent.buildListeners());
    buildable.setKafkaNodePools(fluent.buildKafkaNodePools());
    buildable.setClusterId(fluent.getClusterId());
    buildable.setOperatorLastSuccessfulVersion(fluent.getOperatorLastSuccessfulVersion());
    buildable.setKafkaVersion(fluent.getKafkaVersion());
    buildable.setKafkaMetadataVersion(fluent.getKafkaMetadataVersion());
    buildable.setKafkaMetadataState(fluent.getKafkaMetadataState());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}