package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PersistentClaimStorageFluent<A extends PersistentClaimStorageFluent<A>> extends BaseFluent<A>{
  public PersistentClaimStorageFluent() {
  }
  public PersistentClaimStorageFluent(PersistentClaimStorage instance) {
    instance = (instance != null ? instance : new PersistentClaimStorage());

    if (instance != null) {
      this.withSize(instance.getSize());
      this.withStorageClass(instance.getStorageClass());
      this.withSelector(instance.getSelector());
      this.withDeleteClaim(instance.isDeleteClaim());
      this.withOverrides(instance.getOverrides());
      this.withId(instance.getId());
      this.withKraftMetadata(instance.getKraftMetadata());
    }
  }
  private String size;
  private String storageClass;
  private Map<String,String> selector;
  private boolean deleteClaim;
  private ArrayList<PersistentClaimStorageOverrideBuilder> overrides;
  private Integer id;
  private KRaftMetadataStorage kraftMetadata;
  public String getSize() {
    return this.size;
  }
  public A withSize(String size) {
    this.size=size; return (A) this;
  }
  public boolean hasSize() {
    return this.size != null;
  }
  public String getStorageClass() {
    return this.storageClass;
  }
  public A withStorageClass(String storageClass) {
    this.storageClass=storageClass; return (A) this;
  }
  public boolean hasStorageClass() {
    return this.storageClass != null;
  }
  public A addToSelector(String key,String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(Map<String,String> map) {
    if(this.selector == null && map != null) { this.selector = new LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(Map<String,String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(Map<String,String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new LinkedHashMap(selector);} return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public boolean isDeleteClaim() {
    return this.deleteClaim;
  }
  public A withDeleteClaim(boolean deleteClaim) {
    this.deleteClaim=deleteClaim; return (A) this;
  }
  public boolean hasDeleteClaim() {
    return true;
  }
  public A addToOverrides(int index,PersistentClaimStorageOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
    PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").add(index, builder); overrides.add(index, builder);}
    return (A)this;
  }
  public A setToOverrides(int index,PersistentClaimStorageOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
    PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").set(index, builder); overrides.set(index, builder);}
    return (A)this;
  }
  public A addToOverrides(io.strimzi.api.kafka.model.kafka.PersistentClaimStorageOverride... items) {
    if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
    for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  public A addAllToOverrides(Collection<PersistentClaimStorageOverride> items) {
    if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
    for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  public A removeFromOverrides(io.strimzi.api.kafka.model.kafka.PersistentClaimStorageOverride... items) {
    if (this.overrides == null) return (A)this;
    for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  public A removeAllFromOverrides(Collection<PersistentClaimStorageOverride> items) {
    if (this.overrides == null) return (A)this;
    for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  public A removeMatchingFromOverrides(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
    if (overrides == null) return (A) this;
    final Iterator<PersistentClaimStorageOverrideBuilder> each = overrides.iterator();
    final List visitables = _visitables.get("overrides");
    while (each.hasNext()) {
      PersistentClaimStorageOverrideBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<PersistentClaimStorageOverride> buildOverrides() {
    return overrides != null ? build(overrides) : null;
  }
  public PersistentClaimStorageOverride buildOverride(int index) {
    return this.overrides.get(index).build();
  }
  public PersistentClaimStorageOverride buildFirstOverride() {
    return this.overrides.get(0).build();
  }
  public PersistentClaimStorageOverride buildLastOverride() {
    return this.overrides.get(overrides.size() - 1).build();
  }
  public PersistentClaimStorageOverride buildMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
    for (PersistentClaimStorageOverrideBuilder item: overrides) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
    for (PersistentClaimStorageOverrideBuilder item: overrides) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOverrides(List<PersistentClaimStorageOverride> overrides) {
    if (this.overrides != null) { _visitables.get("overrides").clear();}
    if (overrides != null) {this.overrides = new ArrayList(); for (PersistentClaimStorageOverride item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
  }
  public A withOverrides(io.strimzi.api.kafka.model.kafka.PersistentClaimStorageOverride... overrides) {
    if (this.overrides != null) {this.overrides.clear(); _visitables.remove("overrides"); }
    if (overrides != null) {for (PersistentClaimStorageOverride item :overrides){ this.addToOverrides(item);}} return (A) this;
  }
  public boolean hasOverrides() {
    return overrides != null && !overrides.isEmpty();
  }
  public OverridesNested<A> addNewOverride() {
    return new OverridesNested(-1, null);
  }
  public OverridesNested<A> addNewOverrideLike(PersistentClaimStorageOverride item) {
    return new OverridesNested(-1, item);
  }
  public OverridesNested<A> setNewOverrideLike(int index,PersistentClaimStorageOverride item) {
    return new OverridesNested(index, item);
  }
  public OverridesNested<A> editOverride(int index) {
    if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public OverridesNested<A> editFirstOverride() {
    if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
    return setNewOverrideLike(0, buildOverride(0));
  }
  public OverridesNested<A> editLastOverride() {
    int index = overrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public OverridesNested<A> editMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
    int index = -1;
    for (int i=0;i<overrides.size();i++) { 
    if (predicate.test(overrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public Integer getId() {
    return this.id;
  }
  public A withId(Integer id) {
    this.id=id; return (A) this;
  }
  public boolean hasId() {
    return this.id != null;
  }
  public KRaftMetadataStorage getKraftMetadata() {
    return this.kraftMetadata;
  }
  public A withKraftMetadata(KRaftMetadataStorage kraftMetadata) {
    this.kraftMetadata=kraftMetadata; return (A) this;
  }
  public boolean hasKraftMetadata() {
    return this.kraftMetadata != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentClaimStorageFluent that = (PersistentClaimStorageFluent) o;
    if (!java.util.Objects.equals(size, that.size)) return false;

    if (!java.util.Objects.equals(storageClass, that.storageClass)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (deleteClaim != that.deleteClaim) return false;
    if (!java.util.Objects.equals(overrides, that.overrides)) return false;

    if (!java.util.Objects.equals(id, that.id)) return false;

    if (!java.util.Objects.equals(kraftMetadata, that.kraftMetadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(size,  storageClass,  selector,  deleteClaim,  overrides,  id,  kraftMetadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (storageClass != null) { sb.append("storageClass:"); sb.append(storageClass + ","); }
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    sb.append("deleteClaim:"); sb.append(deleteClaim + ",");
    if (overrides != null && !overrides.isEmpty()) { sb.append("overrides:"); sb.append(overrides + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (kraftMetadata != null) { sb.append("kraftMetadata:"); sb.append(kraftMetadata); }
    sb.append("}");
    return sb.toString();
  }
  public A withDeleteClaim() {
    return withDeleteClaim(true);
  }
  public class OverridesNested<N> extends PersistentClaimStorageOverrideFluent<OverridesNested<N>> implements Nested<N>{
    OverridesNested(int index,PersistentClaimStorageOverride item) {
      this.index = index;
      this.builder = new PersistentClaimStorageOverrideBuilder(this, item);
    }
    PersistentClaimStorageOverrideBuilder builder;
    int index;
    public N and() {
      return (N) PersistentClaimStorageFluent.this.setToOverrides(index,builder.build());
    }
    public N endOverride() {
      return and();
    }
    
  }
  
}