package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentClaimStorageOverrideBuilder extends PersistentClaimStorageOverrideFluent<PersistentClaimStorageOverrideBuilder> implements VisitableBuilder<PersistentClaimStorageOverride,PersistentClaimStorageOverrideBuilder>{
  public PersistentClaimStorageOverrideBuilder() {
    this(false);
  }
  public PersistentClaimStorageOverrideBuilder(Boolean validationEnabled) {
    this(new PersistentClaimStorageOverride(), validationEnabled);
  }
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentClaimStorageOverride(), validationEnabled);
  }
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent,PersistentClaimStorageOverride instance) {
    this(fluent, instance, false);
  }
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent,PersistentClaimStorageOverride instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PersistentClaimStorageOverride());

    if (instance != null) {
      fluent.withBroker(instance.getBroker());
      fluent.withStorageClass(instance.getStorageClass());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverride instance) {
    this(instance,false);
  }
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverride instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PersistentClaimStorageOverride());

    if (instance != null) {
      this.withBroker(instance.getBroker());
      this.withStorageClass(instance.getStorageClass());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentClaimStorageOverrideFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentClaimStorageOverride build() {
    PersistentClaimStorageOverride buildable = new PersistentClaimStorageOverride();
    buildable.setBroker(fluent.getBroker());
    buildable.setStorageClass(fluent.getStorageClass());
    return buildable;
  }
  
}