package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UsedNodePoolStatusBuilder extends UsedNodePoolStatusFluent<UsedNodePoolStatusBuilder> implements VisitableBuilder<UsedNodePoolStatus,UsedNodePoolStatusBuilder>{
  public UsedNodePoolStatusBuilder() {
    this(false);
  }
  public UsedNodePoolStatusBuilder(Boolean validationEnabled) {
    this(new UsedNodePoolStatus(), validationEnabled);
  }
  public UsedNodePoolStatusBuilder(UsedNodePoolStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public UsedNodePoolStatusBuilder(UsedNodePoolStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UsedNodePoolStatus(), validationEnabled);
  }
  public UsedNodePoolStatusBuilder(UsedNodePoolStatusFluent<?> fluent,UsedNodePoolStatus instance) {
    this(fluent, instance, false);
  }
  public UsedNodePoolStatusBuilder(UsedNodePoolStatusFluent<?> fluent,UsedNodePoolStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new UsedNodePoolStatus());

    if (instance != null) {
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public UsedNodePoolStatusBuilder(UsedNodePoolStatus instance) {
    this(instance,false);
  }
  public UsedNodePoolStatusBuilder(UsedNodePoolStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new UsedNodePoolStatus());

    if (instance != null) {
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  UsedNodePoolStatusFluent<?> fluent;
  Boolean validationEnabled;
  public UsedNodePoolStatus build() {
    UsedNodePoolStatus buildable = new UsedNodePoolStatus();
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}