package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerCapacityBuilder extends BrokerCapacityFluent<BrokerCapacityBuilder> implements VisitableBuilder<BrokerCapacity,BrokerCapacityBuilder>{
  public BrokerCapacityBuilder() {
    this(false);
  }
  public BrokerCapacityBuilder(Boolean validationEnabled) {
    this(new BrokerCapacity(), validationEnabled);
  }
  public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerCapacity(), validationEnabled);
  }
  public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent,BrokerCapacity instance) {
    this(fluent, instance, false);
  }
  public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent,BrokerCapacity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BrokerCapacity());

    if (instance != null) {
      fluent.withDisk(instance.getDisk());
      fluent.withCpuUtilization(instance.getCpuUtilization());
      fluent.withCpu(instance.getCpu());
      fluent.withInboundNetwork(instance.getInboundNetwork());
      fluent.withOutboundNetwork(instance.getOutboundNetwork());
      fluent.withOverrides(instance.getOverrides());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BrokerCapacityBuilder(BrokerCapacity instance) {
    this(instance,false);
  }
  public BrokerCapacityBuilder(BrokerCapacity instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BrokerCapacity());

    if (instance != null) {
      this.withDisk(instance.getDisk());
      this.withCpuUtilization(instance.getCpuUtilization());
      this.withCpu(instance.getCpu());
      this.withInboundNetwork(instance.getInboundNetwork());
      this.withOutboundNetwork(instance.getOutboundNetwork());
      this.withOverrides(instance.getOverrides());
    }
    this.validationEnabled = validationEnabled; 
  }
  BrokerCapacityFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerCapacity build() {
    BrokerCapacity buildable = new BrokerCapacity();
    buildable.setDisk(fluent.getDisk());
    buildable.setCpuUtilization(fluent.getCpuUtilization());
    buildable.setCpu(fluent.getCpu());
    buildable.setInboundNetwork(fluent.getInboundNetwork());
    buildable.setOutboundNetwork(fluent.getOutboundNetwork());
    buildable.setOverrides(fluent.buildOverrides());
    return buildable;
  }
  
}