package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CruiseControlSpecBuilder extends CruiseControlSpecFluent<CruiseControlSpecBuilder> implements VisitableBuilder<CruiseControlSpec,CruiseControlSpecBuilder>{
  public CruiseControlSpecBuilder() {
    this(false);
  }
  public CruiseControlSpecBuilder(Boolean validationEnabled) {
    this(new CruiseControlSpec(), validationEnabled);
  }
  public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CruiseControlSpec(), validationEnabled);
  }
  public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent,CruiseControlSpec instance) {
    this(fluent, instance, false);
  }
  public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent,CruiseControlSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CruiseControlSpec());

    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withTlsSidecar(instance.getTlsSidecar());
      fluent.withResources(instance.getResources());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withLogging(instance.getLogging());
      fluent.withTemplate(instance.getTemplate());
      fluent.withBrokerCapacity(instance.getBrokerCapacity());
      fluent.withConfig(instance.getConfig());
      fluent.withMetricsConfig(instance.getMetricsConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CruiseControlSpecBuilder(CruiseControlSpec instance) {
    this(instance,false);
  }
  public CruiseControlSpecBuilder(CruiseControlSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CruiseControlSpec());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withTlsSidecar(instance.getTlsSidecar());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJvmOptions(instance.getJvmOptions());
      this.withLogging(instance.getLogging());
      this.withTemplate(instance.getTemplate());
      this.withBrokerCapacity(instance.getBrokerCapacity());
      this.withConfig(instance.getConfig());
      this.withMetricsConfig(instance.getMetricsConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  CruiseControlSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CruiseControlSpec build() {
    CruiseControlSpec buildable = new CruiseControlSpec();
    buildable.setImage(fluent.getImage());
    buildable.setTlsSidecar(fluent.buildTlsSidecar());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setLogging(fluent.buildLogging());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setBrokerCapacity(fluent.buildBrokerCapacity());
    buildable.setConfig(fluent.getConfig());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    return buildable;
  }
  
}