package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CruiseControlTemplateBuilder extends CruiseControlTemplateFluent<CruiseControlTemplateBuilder> implements VisitableBuilder<CruiseControlTemplate,CruiseControlTemplateBuilder>{
  public CruiseControlTemplateBuilder() {
    this(false);
  }
  public CruiseControlTemplateBuilder(Boolean validationEnabled) {
    this(new CruiseControlTemplate(), validationEnabled);
  }
  public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CruiseControlTemplate(), validationEnabled);
  }
  public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent,CruiseControlTemplate instance) {
    this(fluent, instance, false);
  }
  public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent,CruiseControlTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CruiseControlTemplate());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPod(instance.getPod());
      fluent.withApiService(instance.getApiService());
      fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      fluent.withCruiseControlContainer(instance.getCruiseControlContainer());
      fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
      fluent.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CruiseControlTemplateBuilder(CruiseControlTemplate instance) {
    this(instance,false);
  }
  public CruiseControlTemplateBuilder(CruiseControlTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CruiseControlTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withApiService(instance.getApiService());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withCruiseControlContainer(instance.getCruiseControlContainer());
      this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  CruiseControlTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public CruiseControlTemplate build() {
    CruiseControlTemplate buildable = new CruiseControlTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setCruiseControlContainer(fluent.buildCruiseControlContainer());
    buildable.setTlsSidecarContainer(fluent.buildTlsSidecarContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  
}