package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EntityUserOperatorSpecBuilder extends EntityUserOperatorSpecFluent<EntityUserOperatorSpecBuilder> implements VisitableBuilder<EntityUserOperatorSpec,EntityUserOperatorSpecBuilder>{
  public EntityUserOperatorSpecBuilder() {
    this(false);
  }
  public EntityUserOperatorSpecBuilder(Boolean validationEnabled) {
    this(new EntityUserOperatorSpec(), validationEnabled);
  }
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EntityUserOperatorSpec(), validationEnabled);
  }
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent,EntityUserOperatorSpec instance) {
    this(fluent, instance, false);
  }
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent,EntityUserOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EntityUserOperatorSpec());

    if (instance != null) {
      fluent.withWatchedNamespace(instance.getWatchedNamespace());
      fluent.withImage(instance.getImage());
      fluent.withSecretPrefix(instance.getSecretPrefix());
      fluent.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
      fluent.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withResources(instance.getResources());
      fluent.withLogging(instance.getLogging());
      fluent.withJvmOptions(instance.getJvmOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpec instance) {
    this(instance,false);
  }
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EntityUserOperatorSpec());

    if (instance != null) {
      this.withWatchedNamespace(instance.getWatchedNamespace());
      this.withImage(instance.getImage());
      this.withSecretPrefix(instance.getSecretPrefix());
      this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
      this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withResources(instance.getResources());
      this.withLogging(instance.getLogging());
      this.withJvmOptions(instance.getJvmOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  EntityUserOperatorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EntityUserOperatorSpec build() {
    EntityUserOperatorSpec buildable = new EntityUserOperatorSpec();
    buildable.setWatchedNamespace(fluent.getWatchedNamespace());
    buildable.setImage(fluent.getImage());
    buildable.setSecretPrefix(fluent.getSecretPrefix());
    buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
    buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setResources(fluent.getResources());
    buildable.setLogging(fluent.buildLogging());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    return buildable;
  }
  
}