package io.strimzi.api.kafka.model.kafka.exporter;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.strimzi.api.kafka.model.common.Probe;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaExporterSpecFluent<A extends KafkaExporterSpecFluent<A>> extends BaseFluent<A>{
  public KafkaExporterSpecFluent() {
  }
  public KafkaExporterSpecFluent(KafkaExporterSpec instance) {
    instance = (instance != null ? instance : new KafkaExporterSpec());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withGroupRegex(instance.getGroupRegex());
      this.withTopicRegex(instance.getTopicRegex());
      this.withTopicExcludeRegex(instance.getTopicExcludeRegex());
      this.withGroupExcludeRegex(instance.getGroupExcludeRegex());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withLogging(instance.getLogging());
      this.withEnableSaramaLogging(instance.getEnableSaramaLogging());
      this.withShowAllOffsets(instance.getShowAllOffsets());
      this.withTemplate(instance.getTemplate());
    }
  }
  private String image;
  private String groupRegex;
  private String topicRegex;
  private String topicExcludeRegex;
  private String groupExcludeRegex;
  private ResourceRequirements resources;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private String logging;
  private boolean enableSaramaLogging;
  private boolean showAllOffsets;
  private KafkaExporterTemplateBuilder template;
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public String getGroupRegex() {
    return this.groupRegex;
  }
  public A withGroupRegex(String groupRegex) {
    this.groupRegex=groupRegex; return (A) this;
  }
  public boolean hasGroupRegex() {
    return this.groupRegex != null;
  }
  public String getTopicRegex() {
    return this.topicRegex;
  }
  public A withTopicRegex(String topicRegex) {
    this.topicRegex=topicRegex; return (A) this;
  }
  public boolean hasTopicRegex() {
    return this.topicRegex != null;
  }
  public String getTopicExcludeRegex() {
    return this.topicExcludeRegex;
  }
  public A withTopicExcludeRegex(String topicExcludeRegex) {
    this.topicExcludeRegex=topicExcludeRegex; return (A) this;
  }
  public boolean hasTopicExcludeRegex() {
    return this.topicExcludeRegex != null;
  }
  public String getGroupExcludeRegex() {
    return this.groupExcludeRegex;
  }
  public A withGroupExcludeRegex(String groupExcludeRegex) {
    this.groupExcludeRegex=groupExcludeRegex; return (A) this;
  }
  public boolean hasGroupExcludeRegex() {
    return this.groupExcludeRegex != null;
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public Probe buildLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public A withLivenessProbe(Probe livenessProbe) {
    _visitables.get("livenessProbe").remove(this.livenessProbe);
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} else { this.livenessProbe = null; _visitables.get("livenessProbe").remove(this.livenessProbe); } return (A) this;
  }
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  public Probe buildReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public A withReadinessProbe(Probe readinessProbe) {
    _visitables.get("readinessProbe").remove(this.readinessProbe);
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} else { this.readinessProbe = null; _visitables.get("readinessProbe").remove(this.readinessProbe); } return (A) this;
  }
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  public String getLogging() {
    return this.logging;
  }
  public A withLogging(String logging) {
    this.logging=logging; return (A) this;
  }
  public boolean hasLogging() {
    return this.logging != null;
  }
  public boolean isEnableSaramaLogging() {
    return this.enableSaramaLogging;
  }
  public A withEnableSaramaLogging(boolean enableSaramaLogging) {
    this.enableSaramaLogging=enableSaramaLogging; return (A) this;
  }
  public boolean hasEnableSaramaLogging() {
    return true;
  }
  public boolean isShowAllOffsets() {
    return this.showAllOffsets;
  }
  public A withShowAllOffsets(boolean showAllOffsets) {
    this.showAllOffsets=showAllOffsets; return (A) this;
  }
  public boolean hasShowAllOffsets() {
    return true;
  }
  public KafkaExporterTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(KafkaExporterTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new KafkaExporterTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(KafkaExporterTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new KafkaExporterTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(KafkaExporterTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaExporterSpecFluent that = (KafkaExporterSpecFluent) o;
    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(groupRegex, that.groupRegex)) return false;

    if (!java.util.Objects.equals(topicRegex, that.topicRegex)) return false;

    if (!java.util.Objects.equals(topicExcludeRegex, that.topicExcludeRegex)) return false;

    if (!java.util.Objects.equals(groupExcludeRegex, that.groupExcludeRegex)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;

    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;

    if (!java.util.Objects.equals(logging, that.logging)) return false;

    if (enableSaramaLogging != that.enableSaramaLogging) return false;
    if (showAllOffsets != that.showAllOffsets) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(image,  groupRegex,  topicRegex,  topicExcludeRegex,  groupExcludeRegex,  resources,  livenessProbe,  readinessProbe,  logging,  enableSaramaLogging,  showAllOffsets,  template,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (groupRegex != null) { sb.append("groupRegex:"); sb.append(groupRegex + ","); }
    if (topicRegex != null) { sb.append("topicRegex:"); sb.append(topicRegex + ","); }
    if (topicExcludeRegex != null) { sb.append("topicExcludeRegex:"); sb.append(topicExcludeRegex + ","); }
    if (groupExcludeRegex != null) { sb.append("groupExcludeRegex:"); sb.append(groupExcludeRegex + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    sb.append("enableSaramaLogging:"); sb.append(enableSaramaLogging + ",");
    sb.append("showAllOffsets:"); sb.append(showAllOffsets + ",");
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  public A withEnableSaramaLogging() {
    return withEnableSaramaLogging(true);
  }
  public A withShowAllOffsets() {
    return withShowAllOffsets(true);
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) KafkaExporterSpecFluent.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe() {
      return and();
    }
    
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) KafkaExporterSpecFluent.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends KafkaExporterTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(KafkaExporterTemplate item) {
      this.builder = new KafkaExporterTemplateBuilder(this, item);
    }
    KafkaExporterTemplateBuilder builder;
    public N and() {
      return (N) KafkaExporterSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}