package io.strimzi.api.kafka.model.kafka.exporter;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaExporterTemplateBuilder extends KafkaExporterTemplateFluent<KafkaExporterTemplateBuilder> implements VisitableBuilder<KafkaExporterTemplate,KafkaExporterTemplateBuilder>{
  public KafkaExporterTemplateBuilder() {
    this(false);
  }
  public KafkaExporterTemplateBuilder(Boolean validationEnabled) {
    this(new KafkaExporterTemplate(), validationEnabled);
  }
  public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaExporterTemplate(), validationEnabled);
  }
  public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent,KafkaExporterTemplate instance) {
    this(fluent, instance, false);
  }
  public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent,KafkaExporterTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaExporterTemplate());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPod(instance.getPod());
      fluent.withService(instance.getService());
      fluent.withContainer(instance.getContainer());
      fluent.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaExporterTemplateBuilder(KafkaExporterTemplate instance) {
    this(instance,false);
  }
  public KafkaExporterTemplateBuilder(KafkaExporterTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaExporterTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withService(instance.getService());
      this.withContainer(instance.getContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaExporterTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaExporterTemplate build() {
    KafkaExporterTemplate buildable = new KafkaExporterTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setService(fluent.buildService());
    buildable.setContainer(fluent.buildContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  
}