package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.common.template.IpFamilyPolicy;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.common.template.IpFamily;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSourceFluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.template.ExternalTrafficPolicy;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GenericKafkaListenerConfigurationFluent<A extends GenericKafkaListenerConfigurationFluent<A>> extends BaseFluent<A>{
  public GenericKafkaListenerConfigurationFluent() {
  }
  public GenericKafkaListenerConfigurationFluent(GenericKafkaListenerConfiguration instance) {
    instance = (instance != null ? instance : new GenericKafkaListenerConfiguration());

    if (instance != null) {
      this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
      this.withControllerClass(instance.getControllerClass());
      this.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
      this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
      this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
      this.withFinalizers(instance.getFinalizers());
      this.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
      this.withBootstrap(instance.getBootstrap());
      this.withBrokers(instance.getBrokers());
      this.withMaxConnections(instance.getMaxConnections());
      this.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
      this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
      this.withIpFamilies(instance.getIpFamilies());
      this.withCreateBootstrapService(instance.getCreateBootstrapService());
    }
  }
  private CertAndKeySecretSourceBuilder brokerCertChainAndKey;
  private String controllerClass;
  private NodeAddressType preferredNodePortAddressType;
  private ExternalTrafficPolicy externalTrafficPolicy;
  private List<String> loadBalancerSourceRanges;
  private List<String> finalizers;
  private Boolean useServiceDnsDomain;
  private GenericKafkaListenerConfigurationBootstrapBuilder bootstrap;
  private ArrayList<GenericKafkaListenerConfigurationBrokerBuilder> brokers;
  private Integer maxConnections;
  private Integer maxConnectionCreationRate;
  private IpFamilyPolicy ipFamilyPolicy;
  private List<IpFamily> ipFamilies;
  private Boolean createBootstrapService;
  public CertAndKeySecretSource buildBrokerCertChainAndKey() {
    return this.brokerCertChainAndKey!=null ?this.brokerCertChainAndKey.build():null;
  }
  public A withBrokerCertChainAndKey(CertAndKeySecretSource brokerCertChainAndKey) {
    _visitables.get("brokerCertChainAndKey").remove(this.brokerCertChainAndKey);
    if (brokerCertChainAndKey!=null){ this.brokerCertChainAndKey= new CertAndKeySecretSourceBuilder(brokerCertChainAndKey); _visitables.get("brokerCertChainAndKey").add(this.brokerCertChainAndKey);} else { this.brokerCertChainAndKey = null; _visitables.get("brokerCertChainAndKey").remove(this.brokerCertChainAndKey); } return (A) this;
  }
  public boolean hasBrokerCertChainAndKey() {
    return this.brokerCertChainAndKey != null;
  }
  public BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKey() {
    return new BrokerCertChainAndKeyNested(null);
  }
  public BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKeyLike(CertAndKeySecretSource item) {
    return new BrokerCertChainAndKeyNested(item);
  }
  public BrokerCertChainAndKeyNested<A> editBrokerCertChainAndKey() {
    return withNewBrokerCertChainAndKeyLike(java.util.Optional.ofNullable(buildBrokerCertChainAndKey()).orElse(null));
  }
  public BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKey() {
    return withNewBrokerCertChainAndKeyLike(java.util.Optional.ofNullable(buildBrokerCertChainAndKey()).orElse(new CertAndKeySecretSourceBuilder().build()));
  }
  public BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKeyLike(CertAndKeySecretSource item) {
    return withNewBrokerCertChainAndKeyLike(java.util.Optional.ofNullable(buildBrokerCertChainAndKey()).orElse(item));
  }
  public String getControllerClass() {
    return this.controllerClass;
  }
  public A withControllerClass(String controllerClass) {
    this.controllerClass=controllerClass; return (A) this;
  }
  public boolean hasControllerClass() {
    return this.controllerClass != null;
  }
  public NodeAddressType getPreferredNodePortAddressType() {
    return this.preferredNodePortAddressType;
  }
  public A withPreferredNodePortAddressType(NodeAddressType preferredNodePortAddressType) {
    this.preferredNodePortAddressType=preferredNodePortAddressType; return (A) this;
  }
  public boolean hasPreferredNodePortAddressType() {
    return this.preferredNodePortAddressType != null;
  }
  public ExternalTrafficPolicy getExternalTrafficPolicy() {
    return this.externalTrafficPolicy;
  }
  public A withExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
    this.externalTrafficPolicy=externalTrafficPolicy; return (A) this;
  }
  public boolean hasExternalTrafficPolicy() {
    return this.externalTrafficPolicy != null;
  }
  public A addToLoadBalancerSourceRanges(int index,String item) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
    this.loadBalancerSourceRanges.add(index, item);
    return (A)this;
  }
  public A setToLoadBalancerSourceRanges(int index,String item) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
    this.loadBalancerSourceRanges.set(index, item); return (A)this;
  }
  public A addToLoadBalancerSourceRanges(java.lang.String... items) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
    for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
  }
  public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
    if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
    for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
  }
  public A removeFromLoadBalancerSourceRanges(java.lang.String... items) {
    if (this.loadBalancerSourceRanges == null) return (A)this;
    for (String item : items) { this.loadBalancerSourceRanges.remove(item);} return (A)this;
  }
  public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
    if (this.loadBalancerSourceRanges == null) return (A)this;
    for (String item : items) { this.loadBalancerSourceRanges.remove(item);} return (A)this;
  }
  public List<String> getLoadBalancerSourceRanges() {
    return this.loadBalancerSourceRanges;
  }
  public String getLoadBalancerSourceRange(int index) {
    return this.loadBalancerSourceRanges.get(index);
  }
  public String getFirstLoadBalancerSourceRange() {
    return this.loadBalancerSourceRanges.get(0);
  }
  public String getLastLoadBalancerSourceRange() {
    return this.loadBalancerSourceRanges.get(loadBalancerSourceRanges.size() - 1);
  }
  public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
    for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
    for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
    if (loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges = new ArrayList(); for (String item : loadBalancerSourceRanges){this.addToLoadBalancerSourceRanges(item);}} else { this.loadBalancerSourceRanges = null;} return (A) this;
  }
  public A withLoadBalancerSourceRanges(java.lang.String... loadBalancerSourceRanges) {
    if (this.loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges.clear(); _visitables.remove("loadBalancerSourceRanges"); }
    if (loadBalancerSourceRanges != null) {for (String item :loadBalancerSourceRanges){ this.addToLoadBalancerSourceRanges(item);}} return (A) this;
  }
  public boolean hasLoadBalancerSourceRanges() {
    return loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty();
  }
  public A addToFinalizers(int index,String item) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    this.finalizers.add(index, item);
    return (A)this;
  }
  public A setToFinalizers(int index,String item) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    this.finalizers.set(index, item); return (A)this;
  }
  public A addToFinalizers(java.lang.String... items) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    for (String item : items) {this.finalizers.add(item);} return (A)this;
  }
  public A addAllToFinalizers(Collection<String> items) {
    if (this.finalizers == null) {this.finalizers = new ArrayList<String>();}
    for (String item : items) {this.finalizers.add(item);} return (A)this;
  }
  public A removeFromFinalizers(java.lang.String... items) {
    if (this.finalizers == null) return (A)this;
    for (String item : items) { this.finalizers.remove(item);} return (A)this;
  }
  public A removeAllFromFinalizers(Collection<String> items) {
    if (this.finalizers == null) return (A)this;
    for (String item : items) { this.finalizers.remove(item);} return (A)this;
  }
  public List<String> getFinalizers() {
    return this.finalizers;
  }
  public String getFinalizer(int index) {
    return this.finalizers.get(index);
  }
  public String getFirstFinalizer() {
    return this.finalizers.get(0);
  }
  public String getLastFinalizer() {
    return this.finalizers.get(finalizers.size() - 1);
  }
  public String getMatchingFinalizer(Predicate<String> predicate) {
    for (String item: finalizers) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingFinalizer(Predicate<String> predicate) {
    for (String item: finalizers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFinalizers(List<String> finalizers) {
    if (finalizers != null) {this.finalizers = new ArrayList(); for (String item : finalizers){this.addToFinalizers(item);}} else { this.finalizers = null;} return (A) this;
  }
  public A withFinalizers(java.lang.String... finalizers) {
    if (this.finalizers != null) {this.finalizers.clear(); _visitables.remove("finalizers"); }
    if (finalizers != null) {for (String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
  }
  public boolean hasFinalizers() {
    return finalizers != null && !finalizers.isEmpty();
  }
  public Boolean getUseServiceDnsDomain() {
    return this.useServiceDnsDomain;
  }
  public A withUseServiceDnsDomain(Boolean useServiceDnsDomain) {
    this.useServiceDnsDomain=useServiceDnsDomain; return (A) this;
  }
  public boolean hasUseServiceDnsDomain() {
    return this.useServiceDnsDomain != null;
  }
  public GenericKafkaListenerConfigurationBootstrap buildBootstrap() {
    return this.bootstrap!=null ?this.bootstrap.build():null;
  }
  public A withBootstrap(GenericKafkaListenerConfigurationBootstrap bootstrap) {
    _visitables.get("bootstrap").remove(this.bootstrap);
    if (bootstrap!=null){ this.bootstrap= new GenericKafkaListenerConfigurationBootstrapBuilder(bootstrap); _visitables.get("bootstrap").add(this.bootstrap);} else { this.bootstrap = null; _visitables.get("bootstrap").remove(this.bootstrap); } return (A) this;
  }
  public boolean hasBootstrap() {
    return this.bootstrap != null;
  }
  public BootstrapNested<A> withNewBootstrap() {
    return new BootstrapNested(null);
  }
  public BootstrapNested<A> withNewBootstrapLike(GenericKafkaListenerConfigurationBootstrap item) {
    return new BootstrapNested(item);
  }
  public BootstrapNested<A> editBootstrap() {
    return withNewBootstrapLike(java.util.Optional.ofNullable(buildBootstrap()).orElse(null));
  }
  public BootstrapNested<A> editOrNewBootstrap() {
    return withNewBootstrapLike(java.util.Optional.ofNullable(buildBootstrap()).orElse(new GenericKafkaListenerConfigurationBootstrapBuilder().build()));
  }
  public BootstrapNested<A> editOrNewBootstrapLike(GenericKafkaListenerConfigurationBootstrap item) {
    return withNewBootstrapLike(java.util.Optional.ofNullable(buildBootstrap()).orElse(item));
  }
  public A addToBrokers(int index,GenericKafkaListenerConfigurationBroker item) {
    if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
    GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
    if (index < 0 || index >= brokers.size()) { _visitables.get("brokers").add(builder); brokers.add(builder); } else { _visitables.get("brokers").add(index, builder); brokers.add(index, builder);}
    return (A)this;
  }
  public A setToBrokers(int index,GenericKafkaListenerConfigurationBroker item) {
    if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
    GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
    if (index < 0 || index >= brokers.size()) { _visitables.get("brokers").add(builder); brokers.add(builder); } else { _visitables.get("brokers").set(index, builder); brokers.set(index, builder);}
    return (A)this;
  }
  public A addToBrokers(io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBroker... items) {
    if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
    for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
  }
  public A addAllToBrokers(Collection<GenericKafkaListenerConfigurationBroker> items) {
    if (this.brokers == null) {this.brokers = new ArrayList<GenericKafkaListenerConfigurationBrokerBuilder>();}
    for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
  }
  public A removeFromBrokers(io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBroker... items) {
    if (this.brokers == null) return (A)this;
    for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").remove(builder); this.brokers.remove(builder);} return (A)this;
  }
  public A removeAllFromBrokers(Collection<GenericKafkaListenerConfigurationBroker> items) {
    if (this.brokers == null) return (A)this;
    for (GenericKafkaListenerConfigurationBroker item : items) {GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").remove(builder); this.brokers.remove(builder);} return (A)this;
  }
  public A removeMatchingFromBrokers(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
    if (brokers == null) return (A) this;
    final Iterator<GenericKafkaListenerConfigurationBrokerBuilder> each = brokers.iterator();
    final List visitables = _visitables.get("brokers");
    while (each.hasNext()) {
      GenericKafkaListenerConfigurationBrokerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GenericKafkaListenerConfigurationBroker> buildBrokers() {
    return brokers != null ? build(brokers) : null;
  }
  public GenericKafkaListenerConfigurationBroker buildBroker(int index) {
    return this.brokers.get(index).build();
  }
  public GenericKafkaListenerConfigurationBroker buildFirstBroker() {
    return this.brokers.get(0).build();
  }
  public GenericKafkaListenerConfigurationBroker buildLastBroker() {
    return this.brokers.get(brokers.size() - 1).build();
  }
  public GenericKafkaListenerConfigurationBroker buildMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
    for (GenericKafkaListenerConfigurationBrokerBuilder item: brokers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
    for (GenericKafkaListenerConfigurationBrokerBuilder item: brokers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBrokers(List<GenericKafkaListenerConfigurationBroker> brokers) {
    if (this.brokers != null) { _visitables.get("brokers").clear();}
    if (brokers != null) {this.brokers = new ArrayList(); for (GenericKafkaListenerConfigurationBroker item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
  }
  public A withBrokers(io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBroker... brokers) {
    if (this.brokers != null) {this.brokers.clear(); _visitables.remove("brokers"); }
    if (brokers != null) {for (GenericKafkaListenerConfigurationBroker item :brokers){ this.addToBrokers(item);}} return (A) this;
  }
  public boolean hasBrokers() {
    return brokers != null && !brokers.isEmpty();
  }
  public BrokersNested<A> addNewBroker() {
    return new BrokersNested(-1, null);
  }
  public BrokersNested<A> addNewBrokerLike(GenericKafkaListenerConfigurationBroker item) {
    return new BrokersNested(-1, item);
  }
  public BrokersNested<A> setNewBrokerLike(int index,GenericKafkaListenerConfigurationBroker item) {
    return new BrokersNested(index, item);
  }
  public BrokersNested<A> editBroker(int index) {
    if (brokers.size() <= index) throw new RuntimeException("Can't edit brokers. Index exceeds size.");
    return setNewBrokerLike(index, buildBroker(index));
  }
  public BrokersNested<A> editFirstBroker() {
    if (brokers.size() == 0) throw new RuntimeException("Can't edit first brokers. The list is empty.");
    return setNewBrokerLike(0, buildBroker(0));
  }
  public BrokersNested<A> editLastBroker() {
    int index = brokers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last brokers. The list is empty.");
    return setNewBrokerLike(index, buildBroker(index));
  }
  public BrokersNested<A> editMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<brokers.size();i++) { 
    if (predicate.test(brokers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching brokers. No match found.");
    return setNewBrokerLike(index, buildBroker(index));
  }
  public Integer getMaxConnections() {
    return this.maxConnections;
  }
  public A withMaxConnections(Integer maxConnections) {
    this.maxConnections=maxConnections; return (A) this;
  }
  public boolean hasMaxConnections() {
    return this.maxConnections != null;
  }
  public Integer getMaxConnectionCreationRate() {
    return this.maxConnectionCreationRate;
  }
  public A withMaxConnectionCreationRate(Integer maxConnectionCreationRate) {
    this.maxConnectionCreationRate=maxConnectionCreationRate; return (A) this;
  }
  public boolean hasMaxConnectionCreationRate() {
    return this.maxConnectionCreationRate != null;
  }
  public IpFamilyPolicy getIpFamilyPolicy() {
    return this.ipFamilyPolicy;
  }
  public A withIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
    this.ipFamilyPolicy=ipFamilyPolicy; return (A) this;
  }
  public boolean hasIpFamilyPolicy() {
    return this.ipFamilyPolicy != null;
  }
  public A addToIpFamilies(int index,IpFamily item) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    this.ipFamilies.add(index, item);
    return (A)this;
  }
  public A setToIpFamilies(int index,IpFamily item) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    this.ipFamilies.set(index, item); return (A)this;
  }
  public A addToIpFamilies(io.strimzi.api.kafka.model.common.template.IpFamily... items) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
  }
  public A addAllToIpFamilies(Collection<IpFamily> items) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
  }
  public A removeFromIpFamilies(io.strimzi.api.kafka.model.common.template.IpFamily... items) {
    if (this.ipFamilies == null) return (A)this;
    for (IpFamily item : items) { this.ipFamilies.remove(item);} return (A)this;
  }
  public A removeAllFromIpFamilies(Collection<IpFamily> items) {
    if (this.ipFamilies == null) return (A)this;
    for (IpFamily item : items) { this.ipFamilies.remove(item);} return (A)this;
  }
  public List<IpFamily> getIpFamilies() {
    return this.ipFamilies;
  }
  public IpFamily getIpFamily(int index) {
    return this.ipFamilies.get(index);
  }
  public IpFamily getFirstIpFamily() {
    return this.ipFamilies.get(0);
  }
  public IpFamily getLastIpFamily() {
    return this.ipFamilies.get(ipFamilies.size() - 1);
  }
  public IpFamily getMatchingIpFamily(Predicate<IpFamily> predicate) {
    for (IpFamily item: ipFamilies) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingIpFamily(Predicate<IpFamily> predicate) {
    for (IpFamily item: ipFamilies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpFamilies(List<IpFamily> ipFamilies) {
    if (ipFamilies != null) {this.ipFamilies = new ArrayList(); for (IpFamily item : ipFamilies){this.addToIpFamilies(item);}} else { this.ipFamilies = null;} return (A) this;
  }
  public A withIpFamilies(io.strimzi.api.kafka.model.common.template.IpFamily... ipFamilies) {
    if (this.ipFamilies != null) {this.ipFamilies.clear(); _visitables.remove("ipFamilies"); }
    if (ipFamilies != null) {for (IpFamily item :ipFamilies){ this.addToIpFamilies(item);}} return (A) this;
  }
  public boolean hasIpFamilies() {
    return ipFamilies != null && !ipFamilies.isEmpty();
  }
  public Boolean getCreateBootstrapService() {
    return this.createBootstrapService;
  }
  public A withCreateBootstrapService(Boolean createBootstrapService) {
    this.createBootstrapService=createBootstrapService; return (A) this;
  }
  public boolean hasCreateBootstrapService() {
    return this.createBootstrapService != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GenericKafkaListenerConfigurationFluent that = (GenericKafkaListenerConfigurationFluent) o;
    if (!java.util.Objects.equals(brokerCertChainAndKey, that.brokerCertChainAndKey)) return false;

    if (!java.util.Objects.equals(controllerClass, that.controllerClass)) return false;

    if (!java.util.Objects.equals(preferredNodePortAddressType, that.preferredNodePortAddressType)) return false;

    if (!java.util.Objects.equals(externalTrafficPolicy, that.externalTrafficPolicy)) return false;

    if (!java.util.Objects.equals(loadBalancerSourceRanges, that.loadBalancerSourceRanges)) return false;

    if (!java.util.Objects.equals(finalizers, that.finalizers)) return false;

    if (!java.util.Objects.equals(useServiceDnsDomain, that.useServiceDnsDomain)) return false;

    if (!java.util.Objects.equals(bootstrap, that.bootstrap)) return false;

    if (!java.util.Objects.equals(brokers, that.brokers)) return false;

    if (!java.util.Objects.equals(maxConnections, that.maxConnections)) return false;

    if (!java.util.Objects.equals(maxConnectionCreationRate, that.maxConnectionCreationRate)) return false;

    if (!java.util.Objects.equals(ipFamilyPolicy, that.ipFamilyPolicy)) return false;

    if (!java.util.Objects.equals(ipFamilies, that.ipFamilies)) return false;

    if (!java.util.Objects.equals(createBootstrapService, that.createBootstrapService)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(brokerCertChainAndKey,  controllerClass,  preferredNodePortAddressType,  externalTrafficPolicy,  loadBalancerSourceRanges,  finalizers,  useServiceDnsDomain,  bootstrap,  brokers,  maxConnections,  maxConnectionCreationRate,  ipFamilyPolicy,  ipFamilies,  createBootstrapService,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (brokerCertChainAndKey != null) { sb.append("brokerCertChainAndKey:"); sb.append(brokerCertChainAndKey + ","); }
    if (controllerClass != null) { sb.append("controllerClass:"); sb.append(controllerClass + ","); }
    if (preferredNodePortAddressType != null) { sb.append("preferredNodePortAddressType:"); sb.append(preferredNodePortAddressType + ","); }
    if (externalTrafficPolicy != null) { sb.append("externalTrafficPolicy:"); sb.append(externalTrafficPolicy + ","); }
    if (loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty()) { sb.append("loadBalancerSourceRanges:"); sb.append(loadBalancerSourceRanges + ","); }
    if (finalizers != null && !finalizers.isEmpty()) { sb.append("finalizers:"); sb.append(finalizers + ","); }
    if (useServiceDnsDomain != null) { sb.append("useServiceDnsDomain:"); sb.append(useServiceDnsDomain + ","); }
    if (bootstrap != null) { sb.append("bootstrap:"); sb.append(bootstrap + ","); }
    if (brokers != null && !brokers.isEmpty()) { sb.append("brokers:"); sb.append(brokers + ","); }
    if (maxConnections != null) { sb.append("maxConnections:"); sb.append(maxConnections + ","); }
    if (maxConnectionCreationRate != null) { sb.append("maxConnectionCreationRate:"); sb.append(maxConnectionCreationRate + ","); }
    if (ipFamilyPolicy != null) { sb.append("ipFamilyPolicy:"); sb.append(ipFamilyPolicy + ","); }
    if (ipFamilies != null && !ipFamilies.isEmpty()) { sb.append("ipFamilies:"); sb.append(ipFamilies + ","); }
    if (createBootstrapService != null) { sb.append("createBootstrapService:"); sb.append(createBootstrapService); }
    sb.append("}");
    return sb.toString();
  }
  public A withUseServiceDnsDomain() {
    return withUseServiceDnsDomain(true);
  }
  public A withCreateBootstrapService() {
    return withCreateBootstrapService(true);
  }
  public class BrokerCertChainAndKeyNested<N> extends CertAndKeySecretSourceFluent<BrokerCertChainAndKeyNested<N>> implements Nested<N>{
    BrokerCertChainAndKeyNested(CertAndKeySecretSource item) {
      this.builder = new CertAndKeySecretSourceBuilder(this, item);
    }
    CertAndKeySecretSourceBuilder builder;
    public N and() {
      return (N) GenericKafkaListenerConfigurationFluent.this.withBrokerCertChainAndKey(builder.build());
    }
    public N endBrokerCertChainAndKey() {
      return and();
    }
    
  }
  public class BootstrapNested<N> extends GenericKafkaListenerConfigurationBootstrapFluent<BootstrapNested<N>> implements Nested<N>{
    BootstrapNested(GenericKafkaListenerConfigurationBootstrap item) {
      this.builder = new GenericKafkaListenerConfigurationBootstrapBuilder(this, item);
    }
    GenericKafkaListenerConfigurationBootstrapBuilder builder;
    public N and() {
      return (N) GenericKafkaListenerConfigurationFluent.this.withBootstrap(builder.build());
    }
    public N endBootstrap() {
      return and();
    }
    
  }
  public class BrokersNested<N> extends GenericKafkaListenerConfigurationBrokerFluent<BrokersNested<N>> implements Nested<N>{
    BrokersNested(int index,GenericKafkaListenerConfigurationBroker item) {
      this.index = index;
      this.builder = new GenericKafkaListenerConfigurationBrokerBuilder(this, item);
    }
    GenericKafkaListenerConfigurationBrokerBuilder builder;
    int index;
    public N and() {
      return (N) GenericKafkaListenerConfigurationFluent.this.setToBrokers(index,builder.build());
    }
    public N endBroker() {
      return and();
    }
    
  }
  
}