package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaListenerAuthenticationOAuthBuilder extends KafkaListenerAuthenticationOAuthFluent<KafkaListenerAuthenticationOAuthBuilder> implements VisitableBuilder<KafkaListenerAuthenticationOAuth,KafkaListenerAuthenticationOAuthBuilder>{
  public KafkaListenerAuthenticationOAuthBuilder() {
    this(false);
  }
  public KafkaListenerAuthenticationOAuthBuilder(Boolean validationEnabled) {
    this(new KafkaListenerAuthenticationOAuth(), validationEnabled);
  }
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaListenerAuthenticationOAuth(), validationEnabled);
  }
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent,KafkaListenerAuthenticationOAuth instance) {
    this(fluent, instance, false);
  }
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent,KafkaListenerAuthenticationOAuth instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaListenerAuthenticationOAuth());

    if (instance != null) {
      fluent.withClientId(instance.getClientId());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withValidIssuerUri(instance.getValidIssuerUri());
      fluent.withCheckIssuer(instance.isCheckIssuer());
      fluent.withCheckAudience(instance.isCheckAudience());
      fluent.withJwksEndpointUri(instance.getJwksEndpointUri());
      fluent.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
      fluent.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
      fluent.withJwksExpirySeconds(instance.getJwksExpirySeconds());
      fluent.withJwksIgnoreKeyUse(instance.getJwksIgnoreKeyUse());
      fluent.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
      fluent.withUserNameClaim(instance.getUserNameClaim());
      fluent.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
      fluent.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
      fluent.withGroupsClaim(instance.getGroupsClaim());
      fluent.withGroupsClaimDelimiter(instance.getGroupsClaimDelimiter());
      fluent.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
      fluent.withCheckAccessTokenType(instance.isCheckAccessTokenType());
      fluent.withValidTokenType(instance.getValidTokenType());
      fluent.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
      fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      fluent.withEnableECDSA(instance.getEnableECDSA());
      fluent.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
      fluent.withEnablePlain(instance.isEnablePlain());
      fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
      fluent.withEnableOauthBearer(instance.isEnableOauthBearer());
      fluent.withCustomClaimCheck(instance.getCustomClaimCheck());
      fluent.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      fluent.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      fluent.withHttpRetries(instance.getHttpRetries());
      fluent.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
      fluent.withClientScope(instance.getClientScope());
      fluent.withClientAudience(instance.getClientAudience());
      fluent.withEnableMetrics(instance.isEnableMetrics());
      fluent.withFailFast(instance.getFailFast());
      fluent.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuth instance) {
    this(instance,false);
  }
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuth instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaListenerAuthenticationOAuth());

    if (instance != null) {
      this.withClientId(instance.getClientId());
      this.withClientSecret(instance.getClientSecret());
      this.withValidIssuerUri(instance.getValidIssuerUri());
      this.withCheckIssuer(instance.isCheckIssuer());
      this.withCheckAudience(instance.isCheckAudience());
      this.withJwksEndpointUri(instance.getJwksEndpointUri());
      this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
      this.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
      this.withJwksExpirySeconds(instance.getJwksExpirySeconds());
      this.withJwksIgnoreKeyUse(instance.getJwksIgnoreKeyUse());
      this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
      this.withUserNameClaim(instance.getUserNameClaim());
      this.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
      this.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
      this.withGroupsClaim(instance.getGroupsClaim());
      this.withGroupsClaimDelimiter(instance.getGroupsClaimDelimiter());
      this.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
      this.withCheckAccessTokenType(instance.isCheckAccessTokenType());
      this.withValidTokenType(instance.getValidTokenType());
      this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
      this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      this.withEnableECDSA(instance.getEnableECDSA());
      this.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
      this.withEnablePlain(instance.isEnablePlain());
      this.withTokenEndpointUri(instance.getTokenEndpointUri());
      this.withEnableOauthBearer(instance.isEnableOauthBearer());
      this.withCustomClaimCheck(instance.getCustomClaimCheck());
      this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      this.withHttpRetries(instance.getHttpRetries());
      this.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
      this.withClientScope(instance.getClientScope());
      this.withClientAudience(instance.getClientAudience());
      this.withEnableMetrics(instance.isEnableMetrics());
      this.withFailFast(instance.getFailFast());
      this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaListenerAuthenticationOAuthFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaListenerAuthenticationOAuth build() {
    KafkaListenerAuthenticationOAuth buildable = new KafkaListenerAuthenticationOAuth();
    buildable.setClientId(fluent.getClientId());
    buildable.setClientSecret(fluent.buildClientSecret());
    buildable.setValidIssuerUri(fluent.getValidIssuerUri());
    buildable.setCheckIssuer(fluent.isCheckIssuer());
    buildable.setCheckAudience(fluent.isCheckAudience());
    buildable.setJwksEndpointUri(fluent.getJwksEndpointUri());
    buildable.setJwksRefreshSeconds(fluent.getJwksRefreshSeconds());
    buildable.setJwksMinRefreshPauseSeconds(fluent.getJwksMinRefreshPauseSeconds());
    buildable.setJwksExpirySeconds(fluent.getJwksExpirySeconds());
    buildable.setJwksIgnoreKeyUse(fluent.isJwksIgnoreKeyUse());
    buildable.setIntrospectionEndpointUri(fluent.getIntrospectionEndpointUri());
    buildable.setUserNameClaim(fluent.getUserNameClaim());
    buildable.setFallbackUserNameClaim(fluent.getFallbackUserNameClaim());
    buildable.setFallbackUserNamePrefix(fluent.getFallbackUserNamePrefix());
    buildable.setGroupsClaim(fluent.getGroupsClaim());
    buildable.setGroupsClaimDelimiter(fluent.getGroupsClaimDelimiter());
    buildable.setUserInfoEndpointUri(fluent.getUserInfoEndpointUri());
    buildable.setCheckAccessTokenType(fluent.isCheckAccessTokenType());
    buildable.setValidTokenType(fluent.getValidTokenType());
    buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
    buildable.setEnableECDSA(fluent.getEnableECDSA());
    buildable.setMaxSecondsWithoutReauthentication(fluent.getMaxSecondsWithoutReauthentication());
    buildable.setEnablePlain(fluent.isEnablePlain());
    buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
    buildable.setEnableOauthBearer(fluent.isEnableOauthBearer());
    buildable.setCustomClaimCheck(fluent.getCustomClaimCheck());
    buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
    buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
    buildable.setHttpRetries(fluent.getHttpRetries());
    buildable.setHttpRetryPauseMs(fluent.getHttpRetryPauseMs());
    buildable.setClientScope(fluent.getClientScope());
    buildable.setClientAudience(fluent.getClientAudience());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setFailFast(fluent.isFailFast());
    buildable.setIncludeAcceptHeader(fluent.isIncludeAcceptHeader());
    return buildable;
  }
  
}