package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ListenerStatusBuilder extends ListenerStatusFluent<ListenerStatusBuilder> implements VisitableBuilder<ListenerStatus,ListenerStatusBuilder>{
  public ListenerStatusBuilder() {
    this(false);
  }
  public ListenerStatusBuilder(Boolean validationEnabled) {
    this(new ListenerStatus(), validationEnabled);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ListenerStatus(), validationEnabled);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,ListenerStatus instance) {
    this(fluent, instance, false);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,ListenerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ListenerStatus());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withName(instance.getName());
      fluent.withAddresses(instance.getAddresses());
      fluent.withCertificates(instance.getCertificates());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ListenerStatusBuilder(ListenerStatus instance) {
    this(instance,false);
  }
  public ListenerStatusBuilder(ListenerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ListenerStatus());

    if (instance != null) {
      this.withType(instance.getType());
      this.withName(instance.getName());
      this.withAddresses(instance.getAddresses());
      this.withCertificates(instance.getCertificates());
    }
    this.validationEnabled = validationEnabled; 
  }
  ListenerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ListenerStatus build() {
    ListenerStatus buildable = new ListenerStatus();
    buildable.setType(fluent.getType());
    buildable.setName(fluent.getName());
    buildable.setAddresses(fluent.buildAddresses());
    buildable.setCertificates(fluent.getCertificates());
    return buildable;
  }
  
}