package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ListenerStatusFluent<A extends ListenerStatusFluent<A>> extends BaseFluent<A>{
  public ListenerStatusFluent() {
  }
  public ListenerStatusFluent(ListenerStatus instance) {
    instance = (instance != null ? instance : new ListenerStatus());

    if (instance != null) {
      this.withType(instance.getType());
      this.withName(instance.getName());
      this.withAddresses(instance.getAddresses());
      this.withCertificates(instance.getCertificates());
    }
  }
  private String type;
  private String name;
  private ArrayList<ListenerAddressBuilder> addresses;
  private List<String> certificates;
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public A addToAddresses(int index,ListenerAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
    ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) { _visitables.get("addresses").add(builder); addresses.add(builder); } else { _visitables.get("addresses").add(index, builder); addresses.add(index, builder);}
    return (A)this;
  }
  public A setToAddresses(int index,ListenerAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
    ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) { _visitables.get("addresses").add(builder); addresses.add(builder); } else { _visitables.get("addresses").set(index, builder); addresses.set(index, builder);}
    return (A)this;
  }
  public A addToAddresses(io.strimzi.api.kafka.model.kafka.listener.ListenerAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
    for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(Collection<ListenerAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<ListenerAddressBuilder>();}
    for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.strimzi.api.kafka.model.kafka.listener.ListenerAddress... items) {
    if (this.addresses == null) return (A)this;
    for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  public A removeAllFromAddresses(Collection<ListenerAddress> items) {
    if (this.addresses == null) return (A)this;
    for (ListenerAddress item : items) {ListenerAddressBuilder builder = new ListenerAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  public A removeMatchingFromAddresses(Predicate<ListenerAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<ListenerAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      ListenerAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ListenerAddress> buildAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public ListenerAddress buildAddress(int index) {
    return this.addresses.get(index).build();
  }
  public ListenerAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public ListenerAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public ListenerAddress buildMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
    for (ListenerAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
    for (ListenerAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<ListenerAddress> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").clear();}
    if (addresses != null) {this.addresses = new ArrayList(); for (ListenerAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.strimzi.api.kafka.model.kafka.listener.ListenerAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear(); _visitables.remove("addresses"); }
    if (addresses != null) {for (ListenerAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public AddressesNested<A> addNewAddress() {
    return new AddressesNested(-1, null);
  }
  public AddressesNested<A> addNewAddressLike(ListenerAddress item) {
    return new AddressesNested(-1, item);
  }
  public AddressesNested<A> setNewAddressLike(int index,ListenerAddress item) {
    return new AddressesNested(index, item);
  }
  public AddressesNested<A> editAddress(int index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public AddressesNested<A> editMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public A addToCertificates(int index,String item) {
    if (this.certificates == null) {this.certificates = new ArrayList<String>();}
    this.certificates.add(index, item);
    return (A)this;
  }
  public A setToCertificates(int index,String item) {
    if (this.certificates == null) {this.certificates = new ArrayList<String>();}
    this.certificates.set(index, item); return (A)this;
  }
  public A addToCertificates(java.lang.String... items) {
    if (this.certificates == null) {this.certificates = new ArrayList<String>();}
    for (String item : items) {this.certificates.add(item);} return (A)this;
  }
  public A addAllToCertificates(Collection<String> items) {
    if (this.certificates == null) {this.certificates = new ArrayList<String>();}
    for (String item : items) {this.certificates.add(item);} return (A)this;
  }
  public A removeFromCertificates(java.lang.String... items) {
    if (this.certificates == null) return (A)this;
    for (String item : items) { this.certificates.remove(item);} return (A)this;
  }
  public A removeAllFromCertificates(Collection<String> items) {
    if (this.certificates == null) return (A)this;
    for (String item : items) { this.certificates.remove(item);} return (A)this;
  }
  public List<String> getCertificates() {
    return this.certificates;
  }
  public String getCertificate(int index) {
    return this.certificates.get(index);
  }
  public String getFirstCertificate() {
    return this.certificates.get(0);
  }
  public String getLastCertificate() {
    return this.certificates.get(certificates.size() - 1);
  }
  public String getMatchingCertificate(Predicate<String> predicate) {
    for (String item: certificates) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingCertificate(Predicate<String> predicate) {
    for (String item: certificates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCertificates(List<String> certificates) {
    if (certificates != null) {this.certificates = new ArrayList(); for (String item : certificates){this.addToCertificates(item);}} else { this.certificates = null;} return (A) this;
  }
  public A withCertificates(java.lang.String... certificates) {
    if (this.certificates != null) {this.certificates.clear(); _visitables.remove("certificates"); }
    if (certificates != null) {for (String item :certificates){ this.addToCertificates(item);}} return (A) this;
  }
  public boolean hasCertificates() {
    return certificates != null && !certificates.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ListenerStatusFluent that = (ListenerStatusFluent) o;
    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(addresses, that.addresses)) return false;

    if (!java.util.Objects.equals(certificates, that.certificates)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(type,  name,  addresses,  certificates,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (certificates != null && !certificates.isEmpty()) { sb.append("certificates:"); sb.append(certificates); }
    sb.append("}");
    return sb.toString();
  }
  public class AddressesNested<N> extends ListenerAddressFluent<AddressesNested<N>> implements Nested<N>{
    AddressesNested(int index,ListenerAddress item) {
      this.index = index;
      this.builder = new ListenerAddressBuilder(this, item);
    }
    ListenerAddressBuilder builder;
    int index;
    public N and() {
      return (N) ListenerStatusFluent.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  
}