package io.strimzi.api.kafka.model.kafka.tieredstorage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RemoteStorageManagerBuilder extends RemoteStorageManagerFluent<RemoteStorageManagerBuilder> implements VisitableBuilder<RemoteStorageManager,RemoteStorageManagerBuilder>{
  public RemoteStorageManagerBuilder() {
    this(false);
  }
  public RemoteStorageManagerBuilder(Boolean validationEnabled) {
    this(new RemoteStorageManager(), validationEnabled);
  }
  public RemoteStorageManagerBuilder(RemoteStorageManagerFluent<?> fluent) {
    this(fluent, false);
  }
  public RemoteStorageManagerBuilder(RemoteStorageManagerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RemoteStorageManager(), validationEnabled);
  }
  public RemoteStorageManagerBuilder(RemoteStorageManagerFluent<?> fluent,RemoteStorageManager instance) {
    this(fluent, instance, false);
  }
  public RemoteStorageManagerBuilder(RemoteStorageManagerFluent<?> fluent,RemoteStorageManager instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RemoteStorageManager());

    if (instance != null) {
      fluent.withClassName(instance.getClassName());
      fluent.withClassPath(instance.getClassPath());
      fluent.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RemoteStorageManagerBuilder(RemoteStorageManager instance) {
    this(instance,false);
  }
  public RemoteStorageManagerBuilder(RemoteStorageManager instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RemoteStorageManager());

    if (instance != null) {
      this.withClassName(instance.getClassName());
      this.withClassPath(instance.getClassPath());
      this.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  RemoteStorageManagerFluent<?> fluent;
  Boolean validationEnabled;
  public RemoteStorageManager build() {
    RemoteStorageManager buildable = new RemoteStorageManager();
    buildable.setClassName(fluent.getClassName());
    buildable.setClassPath(fluent.getClassPath());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  
}