package io.strimzi.api.kafka.model.kafka.tieredstorage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TieredStorageCustomBuilder extends TieredStorageCustomFluent<TieredStorageCustomBuilder> implements VisitableBuilder<TieredStorageCustom,TieredStorageCustomBuilder>{
  public TieredStorageCustomBuilder() {
    this(false);
  }
  public TieredStorageCustomBuilder(Boolean validationEnabled) {
    this(new TieredStorageCustom(), validationEnabled);
  }
  public TieredStorageCustomBuilder(TieredStorageCustomFluent<?> fluent) {
    this(fluent, false);
  }
  public TieredStorageCustomBuilder(TieredStorageCustomFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TieredStorageCustom(), validationEnabled);
  }
  public TieredStorageCustomBuilder(TieredStorageCustomFluent<?> fluent,TieredStorageCustom instance) {
    this(fluent, instance, false);
  }
  public TieredStorageCustomBuilder(TieredStorageCustomFluent<?> fluent,TieredStorageCustom instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TieredStorageCustom());

    if (instance != null) {
      fluent.withRemoteStorageManager(instance.getRemoteStorageManager());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TieredStorageCustomBuilder(TieredStorageCustom instance) {
    this(instance,false);
  }
  public TieredStorageCustomBuilder(TieredStorageCustom instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TieredStorageCustom());

    if (instance != null) {
      this.withRemoteStorageManager(instance.getRemoteStorageManager());
    }
    this.validationEnabled = validationEnabled; 
  }
  TieredStorageCustomFluent<?> fluent;
  Boolean validationEnabled;
  public TieredStorageCustom build() {
    TieredStorageCustom buildable = new TieredStorageCustom();
    buildable.setRemoteStorageManager(fluent.buildRemoteStorageManager());
    return buildable;
  }
  
}