package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMakerConsumerSpecBuilder extends KafkaMirrorMakerConsumerSpecFluent<KafkaMirrorMakerConsumerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerConsumerSpec,KafkaMirrorMakerConsumerSpecBuilder>{
  public KafkaMirrorMakerConsumerSpecBuilder() {
    this(false);
  }
  public KafkaMirrorMakerConsumerSpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMakerConsumerSpec(), validationEnabled);
  }
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMakerConsumerSpec(), validationEnabled);
  }
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent,KafkaMirrorMakerConsumerSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent,KafkaMirrorMakerConsumerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMakerConsumerSpec());

    if (instance != null) {
      fluent.withNumStreams(instance.getNumStreams());
      fluent.withGroupId(instance.getGroupId());
      fluent.withOffsetCommitInterval(instance.getOffsetCommitInterval());
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withConfig(instance.getConfig());
      fluent.withTls(instance.getTls());
      fluent.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpec instance) {
    this(instance,false);
  }
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMakerConsumerSpec());

    if (instance != null) {
      this.withNumStreams(instance.getNumStreams());
      this.withGroupId(instance.getGroupId());
      this.withOffsetCommitInterval(instance.getOffsetCommitInterval());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withConfig(instance.getConfig());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMakerConsumerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMakerConsumerSpec build() {
    KafkaMirrorMakerConsumerSpec buildable = new KafkaMirrorMakerConsumerSpec();
    buildable.setNumStreams(fluent.getNumStreams());
    buildable.setGroupId(fluent.getGroupId());
    buildable.setOffsetCommitInterval(fluent.getOffsetCommitInterval());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  
}