package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMakerProducerSpecBuilder extends KafkaMirrorMakerProducerSpecFluent<KafkaMirrorMakerProducerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerProducerSpec,KafkaMirrorMakerProducerSpecBuilder>{
  public KafkaMirrorMakerProducerSpecBuilder() {
    this(false);
  }
  public KafkaMirrorMakerProducerSpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMakerProducerSpec(), validationEnabled);
  }
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMakerProducerSpec(), validationEnabled);
  }
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpecFluent<?> fluent,KafkaMirrorMakerProducerSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpecFluent<?> fluent,KafkaMirrorMakerProducerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMakerProducerSpec());

    if (instance != null) {
      fluent.withAbortOnSendFailure(instance.getAbortOnSendFailure());
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withConfig(instance.getConfig());
      fluent.withTls(instance.getTls());
      fluent.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpec instance) {
    this(instance,false);
  }
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMakerProducerSpec());

    if (instance != null) {
      this.withAbortOnSendFailure(instance.getAbortOnSendFailure());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withConfig(instance.getConfig());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMakerProducerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMakerProducerSpec build() {
    KafkaMirrorMakerProducerSpec buildable = new KafkaMirrorMakerProducerSpec();
    buildable.setAbortOnSendFailure(fluent.getAbortOnSendFailure());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  
}