package io.strimzi.api.kafka.model.mirrormaker;

import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateFluent;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaMirrorMakerTemplateFluent<A extends KafkaMirrorMakerTemplateFluent<A>> extends BaseFluent<A>{
  public KafkaMirrorMakerTemplateFluent() {
  }
  public KafkaMirrorMakerTemplateFluent(KafkaMirrorMakerTemplate instance) {
    instance = (instance != null ? instance : new KafkaMirrorMakerTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withMirrorMakerContainer(instance.getMirrorMakerContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
  }
  private DeploymentTemplateBuilder deployment;
  private PodTemplateBuilder pod;
  private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
  private ContainerTemplateBuilder mirrorMakerContainer;
  private ResourceTemplateBuilder serviceAccount;
  public DeploymentTemplate buildDeployment() {
    return this.deployment!=null ?this.deployment.build():null;
  }
  public A withDeployment(DeploymentTemplate deployment) {
    _visitables.get("deployment").remove(this.deployment);
    if (deployment!=null){ this.deployment= new DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} else { this.deployment = null; _visitables.get("deployment").remove(this.deployment); } return (A) this;
  }
  public boolean hasDeployment() {
    return this.deployment != null;
  }
  public DeploymentNested<A> withNewDeployment() {
    return new DeploymentNested(null);
  }
  public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
    return new DeploymentNested(item);
  }
  public DeploymentNested<A> editDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(null));
  }
  public DeploymentNested<A> editOrNewDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
  }
  public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(item));
  }
  public PodTemplate buildPod() {
    return this.pod!=null ?this.pod.build():null;
  }
  public A withPod(PodTemplate pod) {
    _visitables.get("pod").remove(this.pod);
    if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} else { this.pod = null; _visitables.get("pod").remove(this.pod); } return (A) this;
  }
  public boolean hasPod() {
    return this.pod != null;
  }
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
    return this.podDisruptionBudget!=null ?this.podDisruptionBudget.build():null;
  }
  public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
    _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
    if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} else { this.podDisruptionBudget = null; _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget); } return (A) this;
  }
  public boolean hasPodDisruptionBudget() {
    return this.podDisruptionBudget != null;
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
    return new PodDisruptionBudgetNested(null);
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return new PodDisruptionBudgetNested(item);
  }
  public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(null));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(item));
  }
  public ContainerTemplate buildMirrorMakerContainer() {
    return this.mirrorMakerContainer!=null ?this.mirrorMakerContainer.build():null;
  }
  public A withMirrorMakerContainer(ContainerTemplate mirrorMakerContainer) {
    _visitables.get("mirrorMakerContainer").remove(this.mirrorMakerContainer);
    if (mirrorMakerContainer!=null){ this.mirrorMakerContainer= new ContainerTemplateBuilder(mirrorMakerContainer); _visitables.get("mirrorMakerContainer").add(this.mirrorMakerContainer);} else { this.mirrorMakerContainer = null; _visitables.get("mirrorMakerContainer").remove(this.mirrorMakerContainer); } return (A) this;
  }
  public boolean hasMirrorMakerContainer() {
    return this.mirrorMakerContainer != null;
  }
  public MirrorMakerContainerNested<A> withNewMirrorMakerContainer() {
    return new MirrorMakerContainerNested(null);
  }
  public MirrorMakerContainerNested<A> withNewMirrorMakerContainerLike(ContainerTemplate item) {
    return new MirrorMakerContainerNested(item);
  }
  public MirrorMakerContainerNested<A> editMirrorMakerContainer() {
    return withNewMirrorMakerContainerLike(java.util.Optional.ofNullable(buildMirrorMakerContainer()).orElse(null));
  }
  public MirrorMakerContainerNested<A> editOrNewMirrorMakerContainer() {
    return withNewMirrorMakerContainerLike(java.util.Optional.ofNullable(buildMirrorMakerContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public MirrorMakerContainerNested<A> editOrNewMirrorMakerContainerLike(ContainerTemplate item) {
    return withNewMirrorMakerContainerLike(java.util.Optional.ofNullable(buildMirrorMakerContainer()).orElse(item));
  }
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaMirrorMakerTemplateFluent that = (KafkaMirrorMakerTemplateFluent) o;
    if (!java.util.Objects.equals(deployment, that.deployment)) return false;

    if (!java.util.Objects.equals(pod, that.pod)) return false;

    if (!java.util.Objects.equals(podDisruptionBudget, that.podDisruptionBudget)) return false;

    if (!java.util.Objects.equals(mirrorMakerContainer, that.mirrorMakerContainer)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(deployment,  pod,  podDisruptionBudget,  mirrorMakerContainer,  serviceAccount,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deployment != null) { sb.append("deployment:"); sb.append(deployment + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (podDisruptionBudget != null) { sb.append("podDisruptionBudget:"); sb.append(podDisruptionBudget + ","); }
    if (mirrorMakerContainer != null) { sb.append("mirrorMakerContainer:"); sb.append(mirrorMakerContainer + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount); }
    sb.append("}");
    return sb.toString();
  }
  public class DeploymentNested<N> extends DeploymentTemplateFluent<DeploymentNested<N>> implements Nested<N>{
    DeploymentNested(DeploymentTemplate item) {
      this.builder = new DeploymentTemplateBuilder(this, item);
    }
    DeploymentTemplateBuilder builder;
    public N and() {
      return (N) KafkaMirrorMakerTemplateFluent.this.withDeployment(builder.build());
    }
    public N endDeployment() {
      return and();
    }
    
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) KafkaMirrorMakerTemplateFluent.this.withPod(builder.build());
    }
    public N endPod() {
      return and();
    }
    
  }
  public class PodDisruptionBudgetNested<N> extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>> implements Nested<N>{
    PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
      this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
    }
    PodDisruptionBudgetTemplateBuilder builder;
    public N and() {
      return (N) KafkaMirrorMakerTemplateFluent.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget() {
      return and();
    }
    
  }
  public class MirrorMakerContainerNested<N> extends ContainerTemplateFluent<MirrorMakerContainerNested<N>> implements Nested<N>{
    MirrorMakerContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) KafkaMirrorMakerTemplateFluent.this.withMirrorMakerContainer(builder.build());
    }
    public N endMirrorMakerContainer() {
      return and();
    }
    
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaMirrorMakerTemplateFluent.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  
}