package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMaker2Builder extends KafkaMirrorMaker2Fluent<KafkaMirrorMaker2Builder> implements VisitableBuilder<KafkaMirrorMaker2,KafkaMirrorMaker2Builder>{
  public KafkaMirrorMaker2Builder() {
    this(false);
  }
  public KafkaMirrorMaker2Builder(Boolean validationEnabled) {
    this(new KafkaMirrorMaker2(), validationEnabled);
  }
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMaker2(), validationEnabled);
  }
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent,KafkaMirrorMaker2 instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent,KafkaMirrorMaker2 instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2 instance) {
    this(instance,false);
  }
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2 instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMaker2Fluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMaker2 build() {
    KafkaMirrorMaker2 buildable = new KafkaMirrorMaker2(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}