package io.strimzi.api.kafka.model.mirrormaker2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaMirrorMaker2MirrorSpecFluent<A extends KafkaMirrorMaker2MirrorSpecFluent<A>> extends BaseFluent<A>{
  public KafkaMirrorMaker2MirrorSpecFluent() {
  }
  public KafkaMirrorMaker2MirrorSpecFluent(KafkaMirrorMaker2MirrorSpec instance) {
    instance = (instance != null ? instance : new KafkaMirrorMaker2MirrorSpec());

    if (instance != null) {
      this.withSourceCluster(instance.getSourceCluster());
      this.withTargetCluster(instance.getTargetCluster());
      this.withSourceConnector(instance.getSourceConnector());
      this.withCheckpointConnector(instance.getCheckpointConnector());
      this.withHeartbeatConnector(instance.getHeartbeatConnector());
      this.withTopicsPattern(instance.getTopicsPattern());
      this.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());
      this.withTopicsExcludePattern(instance.getTopicsExcludePattern());
      this.withGroupsPattern(instance.getGroupsPattern());
      this.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());
      this.withGroupsExcludePattern(instance.getGroupsExcludePattern());
    }
  }
  private String sourceCluster;
  private String targetCluster;
  private KafkaMirrorMaker2ConnectorSpecBuilder sourceConnector;
  private KafkaMirrorMaker2ConnectorSpecBuilder checkpointConnector;
  private KafkaMirrorMaker2ConnectorSpecBuilder heartbeatConnector;
  private String topicsPattern;
  private String topicsBlacklistPattern;
  private String topicsExcludePattern;
  private String groupsPattern;
  private String groupsBlacklistPattern;
  private String groupsExcludePattern;
  public String getSourceCluster() {
    return this.sourceCluster;
  }
  public A withSourceCluster(String sourceCluster) {
    this.sourceCluster=sourceCluster; return (A) this;
  }
  public boolean hasSourceCluster() {
    return this.sourceCluster != null;
  }
  public String getTargetCluster() {
    return this.targetCluster;
  }
  public A withTargetCluster(String targetCluster) {
    this.targetCluster=targetCluster; return (A) this;
  }
  public boolean hasTargetCluster() {
    return this.targetCluster != null;
  }
  public KafkaMirrorMaker2ConnectorSpec buildSourceConnector() {
    return this.sourceConnector!=null ?this.sourceConnector.build():null;
  }
  public A withSourceConnector(KafkaMirrorMaker2ConnectorSpec sourceConnector) {
    _visitables.get("sourceConnector").remove(this.sourceConnector);
    if (sourceConnector!=null){ this.sourceConnector= new KafkaMirrorMaker2ConnectorSpecBuilder(sourceConnector); _visitables.get("sourceConnector").add(this.sourceConnector);} else { this.sourceConnector = null; _visitables.get("sourceConnector").remove(this.sourceConnector); } return (A) this;
  }
  public boolean hasSourceConnector() {
    return this.sourceConnector != null;
  }
  public SourceConnectorNested<A> withNewSourceConnector() {
    return new SourceConnectorNested(null);
  }
  public SourceConnectorNested<A> withNewSourceConnectorLike(KafkaMirrorMaker2ConnectorSpec item) {
    return new SourceConnectorNested(item);
  }
  public SourceConnectorNested<A> editSourceConnector() {
    return withNewSourceConnectorLike(java.util.Optional.ofNullable(buildSourceConnector()).orElse(null));
  }
  public SourceConnectorNested<A> editOrNewSourceConnector() {
    return withNewSourceConnectorLike(java.util.Optional.ofNullable(buildSourceConnector()).orElse(new KafkaMirrorMaker2ConnectorSpecBuilder().build()));
  }
  public SourceConnectorNested<A> editOrNewSourceConnectorLike(KafkaMirrorMaker2ConnectorSpec item) {
    return withNewSourceConnectorLike(java.util.Optional.ofNullable(buildSourceConnector()).orElse(item));
  }
  public KafkaMirrorMaker2ConnectorSpec buildCheckpointConnector() {
    return this.checkpointConnector!=null ?this.checkpointConnector.build():null;
  }
  public A withCheckpointConnector(KafkaMirrorMaker2ConnectorSpec checkpointConnector) {
    _visitables.get("checkpointConnector").remove(this.checkpointConnector);
    if (checkpointConnector!=null){ this.checkpointConnector= new KafkaMirrorMaker2ConnectorSpecBuilder(checkpointConnector); _visitables.get("checkpointConnector").add(this.checkpointConnector);} else { this.checkpointConnector = null; _visitables.get("checkpointConnector").remove(this.checkpointConnector); } return (A) this;
  }
  public boolean hasCheckpointConnector() {
    return this.checkpointConnector != null;
  }
  public CheckpointConnectorNested<A> withNewCheckpointConnector() {
    return new CheckpointConnectorNested(null);
  }
  public CheckpointConnectorNested<A> withNewCheckpointConnectorLike(KafkaMirrorMaker2ConnectorSpec item) {
    return new CheckpointConnectorNested(item);
  }
  public CheckpointConnectorNested<A> editCheckpointConnector() {
    return withNewCheckpointConnectorLike(java.util.Optional.ofNullable(buildCheckpointConnector()).orElse(null));
  }
  public CheckpointConnectorNested<A> editOrNewCheckpointConnector() {
    return withNewCheckpointConnectorLike(java.util.Optional.ofNullable(buildCheckpointConnector()).orElse(new KafkaMirrorMaker2ConnectorSpecBuilder().build()));
  }
  public CheckpointConnectorNested<A> editOrNewCheckpointConnectorLike(KafkaMirrorMaker2ConnectorSpec item) {
    return withNewCheckpointConnectorLike(java.util.Optional.ofNullable(buildCheckpointConnector()).orElse(item));
  }
  public KafkaMirrorMaker2ConnectorSpec buildHeartbeatConnector() {
    return this.heartbeatConnector!=null ?this.heartbeatConnector.build():null;
  }
  public A withHeartbeatConnector(KafkaMirrorMaker2ConnectorSpec heartbeatConnector) {
    _visitables.get("heartbeatConnector").remove(this.heartbeatConnector);
    if (heartbeatConnector!=null){ this.heartbeatConnector= new KafkaMirrorMaker2ConnectorSpecBuilder(heartbeatConnector); _visitables.get("heartbeatConnector").add(this.heartbeatConnector);} else { this.heartbeatConnector = null; _visitables.get("heartbeatConnector").remove(this.heartbeatConnector); } return (A) this;
  }
  public boolean hasHeartbeatConnector() {
    return this.heartbeatConnector != null;
  }
  public HeartbeatConnectorNested<A> withNewHeartbeatConnector() {
    return new HeartbeatConnectorNested(null);
  }
  public HeartbeatConnectorNested<A> withNewHeartbeatConnectorLike(KafkaMirrorMaker2ConnectorSpec item) {
    return new HeartbeatConnectorNested(item);
  }
  public HeartbeatConnectorNested<A> editHeartbeatConnector() {
    return withNewHeartbeatConnectorLike(java.util.Optional.ofNullable(buildHeartbeatConnector()).orElse(null));
  }
  public HeartbeatConnectorNested<A> editOrNewHeartbeatConnector() {
    return withNewHeartbeatConnectorLike(java.util.Optional.ofNullable(buildHeartbeatConnector()).orElse(new KafkaMirrorMaker2ConnectorSpecBuilder().build()));
  }
  public HeartbeatConnectorNested<A> editOrNewHeartbeatConnectorLike(KafkaMirrorMaker2ConnectorSpec item) {
    return withNewHeartbeatConnectorLike(java.util.Optional.ofNullable(buildHeartbeatConnector()).orElse(item));
  }
  public String getTopicsPattern() {
    return this.topicsPattern;
  }
  public A withTopicsPattern(String topicsPattern) {
    this.topicsPattern=topicsPattern; return (A) this;
  }
  public boolean hasTopicsPattern() {
    return this.topicsPattern != null;
  }
  public String getTopicsBlacklistPattern() {
    return this.topicsBlacklistPattern;
  }
  public A withTopicsBlacklistPattern(String topicsBlacklistPattern) {
    this.topicsBlacklistPattern=topicsBlacklistPattern; return (A) this;
  }
  public boolean hasTopicsBlacklistPattern() {
    return this.topicsBlacklistPattern != null;
  }
  public String getTopicsExcludePattern() {
    return this.topicsExcludePattern;
  }
  public A withTopicsExcludePattern(String topicsExcludePattern) {
    this.topicsExcludePattern=topicsExcludePattern; return (A) this;
  }
  public boolean hasTopicsExcludePattern() {
    return this.topicsExcludePattern != null;
  }
  public String getGroupsPattern() {
    return this.groupsPattern;
  }
  public A withGroupsPattern(String groupsPattern) {
    this.groupsPattern=groupsPattern; return (A) this;
  }
  public boolean hasGroupsPattern() {
    return this.groupsPattern != null;
  }
  public String getGroupsBlacklistPattern() {
    return this.groupsBlacklistPattern;
  }
  public A withGroupsBlacklistPattern(String groupsBlacklistPattern) {
    this.groupsBlacklistPattern=groupsBlacklistPattern; return (A) this;
  }
  public boolean hasGroupsBlacklistPattern() {
    return this.groupsBlacklistPattern != null;
  }
  public String getGroupsExcludePattern() {
    return this.groupsExcludePattern;
  }
  public A withGroupsExcludePattern(String groupsExcludePattern) {
    this.groupsExcludePattern=groupsExcludePattern; return (A) this;
  }
  public boolean hasGroupsExcludePattern() {
    return this.groupsExcludePattern != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaMirrorMaker2MirrorSpecFluent that = (KafkaMirrorMaker2MirrorSpecFluent) o;
    if (!java.util.Objects.equals(sourceCluster, that.sourceCluster)) return false;

    if (!java.util.Objects.equals(targetCluster, that.targetCluster)) return false;

    if (!java.util.Objects.equals(sourceConnector, that.sourceConnector)) return false;

    if (!java.util.Objects.equals(checkpointConnector, that.checkpointConnector)) return false;

    if (!java.util.Objects.equals(heartbeatConnector, that.heartbeatConnector)) return false;

    if (!java.util.Objects.equals(topicsPattern, that.topicsPattern)) return false;

    if (!java.util.Objects.equals(topicsBlacklistPattern, that.topicsBlacklistPattern)) return false;

    if (!java.util.Objects.equals(topicsExcludePattern, that.topicsExcludePattern)) return false;

    if (!java.util.Objects.equals(groupsPattern, that.groupsPattern)) return false;

    if (!java.util.Objects.equals(groupsBlacklistPattern, that.groupsBlacklistPattern)) return false;

    if (!java.util.Objects.equals(groupsExcludePattern, that.groupsExcludePattern)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(sourceCluster,  targetCluster,  sourceConnector,  checkpointConnector,  heartbeatConnector,  topicsPattern,  topicsBlacklistPattern,  topicsExcludePattern,  groupsPattern,  groupsBlacklistPattern,  groupsExcludePattern,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sourceCluster != null) { sb.append("sourceCluster:"); sb.append(sourceCluster + ","); }
    if (targetCluster != null) { sb.append("targetCluster:"); sb.append(targetCluster + ","); }
    if (sourceConnector != null) { sb.append("sourceConnector:"); sb.append(sourceConnector + ","); }
    if (checkpointConnector != null) { sb.append("checkpointConnector:"); sb.append(checkpointConnector + ","); }
    if (heartbeatConnector != null) { sb.append("heartbeatConnector:"); sb.append(heartbeatConnector + ","); }
    if (topicsPattern != null) { sb.append("topicsPattern:"); sb.append(topicsPattern + ","); }
    if (topicsBlacklistPattern != null) { sb.append("topicsBlacklistPattern:"); sb.append(topicsBlacklistPattern + ","); }
    if (topicsExcludePattern != null) { sb.append("topicsExcludePattern:"); sb.append(topicsExcludePattern + ","); }
    if (groupsPattern != null) { sb.append("groupsPattern:"); sb.append(groupsPattern + ","); }
    if (groupsBlacklistPattern != null) { sb.append("groupsBlacklistPattern:"); sb.append(groupsBlacklistPattern + ","); }
    if (groupsExcludePattern != null) { sb.append("groupsExcludePattern:"); sb.append(groupsExcludePattern); }
    sb.append("}");
    return sb.toString();
  }
  public class SourceConnectorNested<N> extends KafkaMirrorMaker2ConnectorSpecFluent<SourceConnectorNested<N>> implements Nested<N>{
    SourceConnectorNested(KafkaMirrorMaker2ConnectorSpec item) {
      this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this, item);
    }
    KafkaMirrorMaker2ConnectorSpecBuilder builder;
    public N and() {
      return (N) KafkaMirrorMaker2MirrorSpecFluent.this.withSourceConnector(builder.build());
    }
    public N endSourceConnector() {
      return and();
    }
    
  }
  public class CheckpointConnectorNested<N> extends KafkaMirrorMaker2ConnectorSpecFluent<CheckpointConnectorNested<N>> implements Nested<N>{
    CheckpointConnectorNested(KafkaMirrorMaker2ConnectorSpec item) {
      this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this, item);
    }
    KafkaMirrorMaker2ConnectorSpecBuilder builder;
    public N and() {
      return (N) KafkaMirrorMaker2MirrorSpecFluent.this.withCheckpointConnector(builder.build());
    }
    public N endCheckpointConnector() {
      return and();
    }
    
  }
  public class HeartbeatConnectorNested<N> extends KafkaMirrorMaker2ConnectorSpecFluent<HeartbeatConnectorNested<N>> implements Nested<N>{
    HeartbeatConnectorNested(KafkaMirrorMaker2ConnectorSpec item) {
      this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this, item);
    }
    KafkaMirrorMaker2ConnectorSpecBuilder builder;
    public N and() {
      return (N) KafkaMirrorMaker2MirrorSpecFluent.this.withHeartbeatConnector(builder.build());
    }
    public N endHeartbeatConnector() {
      return and();
    }
    
  }
  
}