package io.strimzi.api.kafka.model.mirrormaker2;

import io.strimzi.api.kafka.model.connect.AbstractKafkaConnectSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaMirrorMaker2SpecFluent<A extends KafkaMirrorMaker2SpecFluent<A>> extends AbstractKafkaConnectSpecFluent<A>{
  public KafkaMirrorMaker2SpecFluent() {
  }
  public KafkaMirrorMaker2SpecFluent(KafkaMirrorMaker2Spec instance) {
    instance = (instance != null ? instance : new KafkaMirrorMaker2Spec());

    if (instance != null) {
      this.withClusters(instance.getClusters());
      this.withConnectCluster(instance.getConnectCluster());
      this.withMirrors(instance.getMirrors());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withVersion(instance.getVersion());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJmxOptions(instance.getJmxOptions());
      this.withJvmOptions(instance.getJvmOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withTracing(instance.getTracing());
      this.withTemplate(instance.getTemplate());
      this.withExternalConfiguration(instance.getExternalConfiguration());
      this.withClientRackInitImage(instance.getClientRackInitImage());
      this.withRack(instance.getRack());
    }
  }
  private ArrayList<KafkaMirrorMaker2ClusterSpecBuilder> clusters;
  private String connectCluster;
  private ArrayList<KafkaMirrorMaker2MirrorSpecBuilder> mirrors;
  public A addToClusters(int index,KafkaMirrorMaker2ClusterSpec item) {
    if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
    KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").add(index, builder); clusters.add(index, builder);}
    return (A)this;
  }
  public A setToClusters(int index,KafkaMirrorMaker2ClusterSpec item) {
    if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
    KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").set(index, builder); clusters.set(index, builder);}
    return (A)this;
  }
  public A addToClusters(io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2ClusterSpec... items) {
    if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
    for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A addAllToClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
    if (this.clusters == null) {this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();}
    for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A removeFromClusters(io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2ClusterSpec... items) {
    if (this.clusters == null) return (A)this;
    for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  public A removeAllFromClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
    if (this.clusters == null) return (A)this;
    for (KafkaMirrorMaker2ClusterSpec item : items) {KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  public A removeMatchingFromClusters(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
    if (clusters == null) return (A) this;
    final Iterator<KafkaMirrorMaker2ClusterSpecBuilder> each = clusters.iterator();
    final List visitables = _visitables.get("clusters");
    while (each.hasNext()) {
      KafkaMirrorMaker2ClusterSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<KafkaMirrorMaker2ClusterSpec> buildClusters() {
    return clusters != null ? build(clusters) : null;
  }
  public KafkaMirrorMaker2ClusterSpec buildCluster(int index) {
    return this.clusters.get(index).build();
  }
  public KafkaMirrorMaker2ClusterSpec buildFirstCluster() {
    return this.clusters.get(0).build();
  }
  public KafkaMirrorMaker2ClusterSpec buildLastCluster() {
    return this.clusters.get(clusters.size() - 1).build();
  }
  public KafkaMirrorMaker2ClusterSpec buildMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
    for (KafkaMirrorMaker2ClusterSpecBuilder item: clusters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
    for (KafkaMirrorMaker2ClusterSpecBuilder item: clusters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusters(List<KafkaMirrorMaker2ClusterSpec> clusters) {
    if (this.clusters != null) { _visitables.get("clusters").clear();}
    if (clusters != null) {this.clusters = new ArrayList(); for (KafkaMirrorMaker2ClusterSpec item : clusters){this.addToClusters(item);}} else { this.clusters = null;} return (A) this;
  }
  public A withClusters(io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2ClusterSpec... clusters) {
    if (this.clusters != null) {this.clusters.clear(); _visitables.remove("clusters"); }
    if (clusters != null) {for (KafkaMirrorMaker2ClusterSpec item :clusters){ this.addToClusters(item);}} return (A) this;
  }
  public boolean hasClusters() {
    return clusters != null && !clusters.isEmpty();
  }
  public ClustersNested<A> addNewCluster() {
    return new ClustersNested(-1, null);
  }
  public ClustersNested<A> addNewClusterLike(KafkaMirrorMaker2ClusterSpec item) {
    return new ClustersNested(-1, item);
  }
  public ClustersNested<A> setNewClusterLike(int index,KafkaMirrorMaker2ClusterSpec item) {
    return new ClustersNested(index, item);
  }
  public ClustersNested<A> editCluster(int index) {
    if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public ClustersNested<A> editFirstCluster() {
    if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
    return setNewClusterLike(0, buildCluster(0));
  }
  public ClustersNested<A> editLastCluster() {
    int index = clusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public ClustersNested<A> editMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusters.size();i++) { 
    if (predicate.test(clusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public String getConnectCluster() {
    return this.connectCluster;
  }
  public A withConnectCluster(String connectCluster) {
    this.connectCluster=connectCluster; return (A) this;
  }
  public boolean hasConnectCluster() {
    return this.connectCluster != null;
  }
  public A addToMirrors(int index,KafkaMirrorMaker2MirrorSpec item) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
    KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
    if (index < 0 || index >= mirrors.size()) { _visitables.get("mirrors").add(builder); mirrors.add(builder); } else { _visitables.get("mirrors").add(index, builder); mirrors.add(index, builder);}
    return (A)this;
  }
  public A setToMirrors(int index,KafkaMirrorMaker2MirrorSpec item) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
    KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
    if (index < 0 || index >= mirrors.size()) { _visitables.get("mirrors").add(builder); mirrors.add(builder); } else { _visitables.get("mirrors").set(index, builder); mirrors.set(index, builder);}
    return (A)this;
  }
  public A addToMirrors(io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2MirrorSpec... items) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
    for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(builder);this.mirrors.add(builder);} return (A)this;
  }
  public A addAllToMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();}
    for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").add(builder);this.mirrors.add(builder);} return (A)this;
  }
  public A removeFromMirrors(io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2MirrorSpec... items) {
    if (this.mirrors == null) return (A)this;
    for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").remove(builder); this.mirrors.remove(builder);} return (A)this;
  }
  public A removeAllFromMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
    if (this.mirrors == null) return (A)this;
    for (KafkaMirrorMaker2MirrorSpec item : items) {KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);_visitables.get("mirrors").remove(builder); this.mirrors.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMirrors(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
    if (mirrors == null) return (A) this;
    final Iterator<KafkaMirrorMaker2MirrorSpecBuilder> each = mirrors.iterator();
    final List visitables = _visitables.get("mirrors");
    while (each.hasNext()) {
      KafkaMirrorMaker2MirrorSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<KafkaMirrorMaker2MirrorSpec> buildMirrors() {
    return mirrors != null ? build(mirrors) : null;
  }
  public KafkaMirrorMaker2MirrorSpec buildMirror(int index) {
    return this.mirrors.get(index).build();
  }
  public KafkaMirrorMaker2MirrorSpec buildFirstMirror() {
    return this.mirrors.get(0).build();
  }
  public KafkaMirrorMaker2MirrorSpec buildLastMirror() {
    return this.mirrors.get(mirrors.size() - 1).build();
  }
  public KafkaMirrorMaker2MirrorSpec buildMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
    for (KafkaMirrorMaker2MirrorSpecBuilder item: mirrors) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
    for (KafkaMirrorMaker2MirrorSpecBuilder item: mirrors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMirrors(List<KafkaMirrorMaker2MirrorSpec> mirrors) {
    if (this.mirrors != null) { _visitables.get("mirrors").clear();}
    if (mirrors != null) {this.mirrors = new ArrayList(); for (KafkaMirrorMaker2MirrorSpec item : mirrors){this.addToMirrors(item);}} else { this.mirrors = null;} return (A) this;
  }
  public A withMirrors(io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2MirrorSpec... mirrors) {
    if (this.mirrors != null) {this.mirrors.clear(); _visitables.remove("mirrors"); }
    if (mirrors != null) {for (KafkaMirrorMaker2MirrorSpec item :mirrors){ this.addToMirrors(item);}} return (A) this;
  }
  public boolean hasMirrors() {
    return mirrors != null && !mirrors.isEmpty();
  }
  public MirrorsNested<A> addNewMirror() {
    return new MirrorsNested(-1, null);
  }
  public MirrorsNested<A> addNewMirrorLike(KafkaMirrorMaker2MirrorSpec item) {
    return new MirrorsNested(-1, item);
  }
  public MirrorsNested<A> setNewMirrorLike(int index,KafkaMirrorMaker2MirrorSpec item) {
    return new MirrorsNested(index, item);
  }
  public MirrorsNested<A> editMirror(int index) {
    if (mirrors.size() <= index) throw new RuntimeException("Can't edit mirrors. Index exceeds size.");
    return setNewMirrorLike(index, buildMirror(index));
  }
  public MirrorsNested<A> editFirstMirror() {
    if (mirrors.size() == 0) throw new RuntimeException("Can't edit first mirrors. The list is empty.");
    return setNewMirrorLike(0, buildMirror(0));
  }
  public MirrorsNested<A> editLastMirror() {
    int index = mirrors.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last mirrors. The list is empty.");
    return setNewMirrorLike(index, buildMirror(index));
  }
  public MirrorsNested<A> editMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<mirrors.size();i++) { 
    if (predicate.test(mirrors.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching mirrors. No match found.");
    return setNewMirrorLike(index, buildMirror(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaMirrorMaker2SpecFluent that = (KafkaMirrorMaker2SpecFluent) o;
    if (!java.util.Objects.equals(clusters, that.clusters)) return false;

    if (!java.util.Objects.equals(connectCluster, that.connectCluster)) return false;

    if (!java.util.Objects.equals(mirrors, that.mirrors)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusters,  connectCluster,  mirrors,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusters != null && !clusters.isEmpty()) { sb.append("clusters:"); sb.append(clusters + ","); }
    if (connectCluster != null) { sb.append("connectCluster:"); sb.append(connectCluster + ","); }
    if (mirrors != null && !mirrors.isEmpty()) { sb.append("mirrors:"); sb.append(mirrors); }
    sb.append("}");
    return sb.toString();
  }
  public class ClustersNested<N> extends KafkaMirrorMaker2ClusterSpecFluent<ClustersNested<N>> implements Nested<N>{
    ClustersNested(int index,KafkaMirrorMaker2ClusterSpec item) {
      this.index = index;
      this.builder = new KafkaMirrorMaker2ClusterSpecBuilder(this, item);
    }
    KafkaMirrorMaker2ClusterSpecBuilder builder;
    int index;
    public N and() {
      return (N) KafkaMirrorMaker2SpecFluent.this.setToClusters(index,builder.build());
    }
    public N endCluster() {
      return and();
    }
    
  }
  public class MirrorsNested<N> extends KafkaMirrorMaker2MirrorSpecFluent<MirrorsNested<N>> implements Nested<N>{
    MirrorsNested(int index,KafkaMirrorMaker2MirrorSpec item) {
      this.index = index;
      this.builder = new KafkaMirrorMaker2MirrorSpecBuilder(this, item);
    }
    KafkaMirrorMaker2MirrorSpecBuilder builder;
    int index;
    public N and() {
      return (N) KafkaMirrorMaker2SpecFluent.this.setToMirrors(index,builder.build());
    }
    public N endMirror() {
      return and();
    }
    
  }
  
}