package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMaker2TemplateBuilder extends KafkaMirrorMaker2TemplateFluent<KafkaMirrorMaker2TemplateBuilder> implements VisitableBuilder<KafkaMirrorMaker2Template,KafkaMirrorMaker2TemplateBuilder>{
  public KafkaMirrorMaker2TemplateBuilder() {
    this(false);
  }
  public KafkaMirrorMaker2TemplateBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMaker2Template(), validationEnabled);
  }
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMaker2Template(), validationEnabled);
  }
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent,KafkaMirrorMaker2Template instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent,KafkaMirrorMaker2Template instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2Template());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPod(instance.getPod());
      fluent.withApiService(instance.getApiService());
      fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      fluent.withMirrorMaker2Container(instance.getMirrorMaker2Container());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2Template instance) {
    this(instance,false);
  }
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2Template instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2Template());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withApiService(instance.getApiService());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withMirrorMaker2Container(instance.getMirrorMaker2Container());
      this.withServiceAccount(instance.getServiceAccount());
      this.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMaker2TemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMaker2Template build() {
    KafkaMirrorMaker2Template buildable = new KafkaMirrorMaker2Template();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setMirrorMaker2Container(fluent.buildMirrorMaker2Container());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  
}