package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaNodePoolBuilder extends KafkaNodePoolFluent<KafkaNodePoolBuilder> implements VisitableBuilder<KafkaNodePool,KafkaNodePoolBuilder>{
  public KafkaNodePoolBuilder() {
    this(false);
  }
  public KafkaNodePoolBuilder(Boolean validationEnabled) {
    this(new KafkaNodePool(), validationEnabled);
  }
  public KafkaNodePoolBuilder(KafkaNodePoolFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaNodePoolBuilder(KafkaNodePoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaNodePool(), validationEnabled);
  }
  public KafkaNodePoolBuilder(KafkaNodePoolFluent<?> fluent,KafkaNodePool instance) {
    this(fluent, instance, false);
  }
  public KafkaNodePoolBuilder(KafkaNodePoolFluent<?> fluent,KafkaNodePool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaNodePool());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaNodePoolBuilder(KafkaNodePool instance) {
    this(instance,false);
  }
  public KafkaNodePoolBuilder(KafkaNodePool instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaNodePool());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaNodePoolFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaNodePool build() {
    KafkaNodePool buildable = new KafkaNodePool(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}