package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaNodePoolStatusBuilder extends KafkaNodePoolStatusFluent<KafkaNodePoolStatusBuilder> implements VisitableBuilder<KafkaNodePoolStatus,KafkaNodePoolStatusBuilder>{
  public KafkaNodePoolStatusBuilder() {
    this(false);
  }
  public KafkaNodePoolStatusBuilder(Boolean validationEnabled) {
    this(new KafkaNodePoolStatus(), validationEnabled);
  }
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaNodePoolStatus(), validationEnabled);
  }
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatusFluent<?> fluent,KafkaNodePoolStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatusFluent<?> fluent,KafkaNodePoolStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaNodePoolStatus());

    if (instance != null) {
      fluent.withNodeIds(instance.getNodeIds());
      fluent.withClusterId(instance.getClusterId());
      fluent.withRoles(instance.getRoles());
      fluent.withReplicas(instance.getReplicas());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatus instance) {
    this(instance,false);
  }
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaNodePoolStatus());

    if (instance != null) {
      this.withNodeIds(instance.getNodeIds());
      this.withClusterId(instance.getClusterId());
      this.withRoles(instance.getRoles());
      this.withReplicas(instance.getReplicas());
      this.withLabelSelector(instance.getLabelSelector());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaNodePoolStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaNodePoolStatus build() {
    KafkaNodePoolStatus buildable = new KafkaNodePoolStatus();
    buildable.setNodeIds(fluent.getNodeIds());
    buildable.setClusterId(fluent.getClusterId());
    buildable.setRoles(fluent.getRoles());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}