package io.strimzi.api.kafka.model.nodepool;

import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaNodePoolTemplateFluent<A extends KafkaNodePoolTemplateFluent<A>> extends SpecFluent<A>{
  public KafkaNodePoolTemplateFluent() {
  }
  public KafkaNodePoolTemplateFluent(KafkaNodePoolTemplate instance) {
    instance = (instance != null ? instance : new KafkaNodePoolTemplate());

    if (instance != null) {
      this.withPodSet(instance.getPodSet());
      this.withPod(instance.getPod());
      this.withPerPodService(instance.getPerPodService());
      this.withPerPodRoute(instance.getPerPodRoute());
      this.withPerPodIngress(instance.getPerPodIngress());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withKafkaContainer(instance.getKafkaContainer());
      this.withInitContainer(instance.getInitContainer());
    }
  }
  private ResourceTemplateBuilder podSet;
  private PodTemplateBuilder pod;
  private ResourceTemplateBuilder perPodService;
  private ResourceTemplateBuilder perPodRoute;
  private ResourceTemplateBuilder perPodIngress;
  private ResourceTemplateBuilder persistentVolumeClaim;
  private ContainerTemplateBuilder kafkaContainer;
  private ContainerTemplateBuilder initContainer;
  public ResourceTemplate buildPodSet() {
    return this.podSet!=null ?this.podSet.build():null;
  }
  public A withPodSet(ResourceTemplate podSet) {
    _visitables.get("podSet").remove(this.podSet);
    if (podSet!=null){ this.podSet= new ResourceTemplateBuilder(podSet); _visitables.get("podSet").add(this.podSet);} else { this.podSet = null; _visitables.get("podSet").remove(this.podSet); } return (A) this;
  }
  public boolean hasPodSet() {
    return this.podSet != null;
  }
  public PodSetNested<A> withNewPodSet() {
    return new PodSetNested(null);
  }
  public PodSetNested<A> withNewPodSetLike(ResourceTemplate item) {
    return new PodSetNested(item);
  }
  public PodSetNested<A> editPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(null));
  }
  public PodSetNested<A> editOrNewPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PodSetNested<A> editOrNewPodSetLike(ResourceTemplate item) {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(item));
  }
  public PodTemplate buildPod() {
    return this.pod!=null ?this.pod.build():null;
  }
  public A withPod(PodTemplate pod) {
    _visitables.get("pod").remove(this.pod);
    if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} else { this.pod = null; _visitables.get("pod").remove(this.pod); } return (A) this;
  }
  public boolean hasPod() {
    return this.pod != null;
  }
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  public ResourceTemplate buildPerPodService() {
    return this.perPodService!=null ?this.perPodService.build():null;
  }
  public A withPerPodService(ResourceTemplate perPodService) {
    _visitables.get("perPodService").remove(this.perPodService);
    if (perPodService!=null){ this.perPodService= new ResourceTemplateBuilder(perPodService); _visitables.get("perPodService").add(this.perPodService);} else { this.perPodService = null; _visitables.get("perPodService").remove(this.perPodService); } return (A) this;
  }
  public boolean hasPerPodService() {
    return this.perPodService != null;
  }
  public PerPodServiceNested<A> withNewPerPodService() {
    return new PerPodServiceNested(null);
  }
  public PerPodServiceNested<A> withNewPerPodServiceLike(ResourceTemplate item) {
    return new PerPodServiceNested(item);
  }
  public PerPodServiceNested<A> editPerPodService() {
    return withNewPerPodServiceLike(java.util.Optional.ofNullable(buildPerPodService()).orElse(null));
  }
  public PerPodServiceNested<A> editOrNewPerPodService() {
    return withNewPerPodServiceLike(java.util.Optional.ofNullable(buildPerPodService()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PerPodServiceNested<A> editOrNewPerPodServiceLike(ResourceTemplate item) {
    return withNewPerPodServiceLike(java.util.Optional.ofNullable(buildPerPodService()).orElse(item));
  }
  public ResourceTemplate buildPerPodRoute() {
    return this.perPodRoute!=null ?this.perPodRoute.build():null;
  }
  public A withPerPodRoute(ResourceTemplate perPodRoute) {
    _visitables.get("perPodRoute").remove(this.perPodRoute);
    if (perPodRoute!=null){ this.perPodRoute= new ResourceTemplateBuilder(perPodRoute); _visitables.get("perPodRoute").add(this.perPodRoute);} else { this.perPodRoute = null; _visitables.get("perPodRoute").remove(this.perPodRoute); } return (A) this;
  }
  public boolean hasPerPodRoute() {
    return this.perPodRoute != null;
  }
  public PerPodRouteNested<A> withNewPerPodRoute() {
    return new PerPodRouteNested(null);
  }
  public PerPodRouteNested<A> withNewPerPodRouteLike(ResourceTemplate item) {
    return new PerPodRouteNested(item);
  }
  public PerPodRouteNested<A> editPerPodRoute() {
    return withNewPerPodRouteLike(java.util.Optional.ofNullable(buildPerPodRoute()).orElse(null));
  }
  public PerPodRouteNested<A> editOrNewPerPodRoute() {
    return withNewPerPodRouteLike(java.util.Optional.ofNullable(buildPerPodRoute()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PerPodRouteNested<A> editOrNewPerPodRouteLike(ResourceTemplate item) {
    return withNewPerPodRouteLike(java.util.Optional.ofNullable(buildPerPodRoute()).orElse(item));
  }
  public ResourceTemplate buildPerPodIngress() {
    return this.perPodIngress!=null ?this.perPodIngress.build():null;
  }
  public A withPerPodIngress(ResourceTemplate perPodIngress) {
    _visitables.get("perPodIngress").remove(this.perPodIngress);
    if (perPodIngress!=null){ this.perPodIngress= new ResourceTemplateBuilder(perPodIngress); _visitables.get("perPodIngress").add(this.perPodIngress);} else { this.perPodIngress = null; _visitables.get("perPodIngress").remove(this.perPodIngress); } return (A) this;
  }
  public boolean hasPerPodIngress() {
    return this.perPodIngress != null;
  }
  public PerPodIngressNested<A> withNewPerPodIngress() {
    return new PerPodIngressNested(null);
  }
  public PerPodIngressNested<A> withNewPerPodIngressLike(ResourceTemplate item) {
    return new PerPodIngressNested(item);
  }
  public PerPodIngressNested<A> editPerPodIngress() {
    return withNewPerPodIngressLike(java.util.Optional.ofNullable(buildPerPodIngress()).orElse(null));
  }
  public PerPodIngressNested<A> editOrNewPerPodIngress() {
    return withNewPerPodIngressLike(java.util.Optional.ofNullable(buildPerPodIngress()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PerPodIngressNested<A> editOrNewPerPodIngressLike(ResourceTemplate item) {
    return withNewPerPodIngressLike(java.util.Optional.ofNullable(buildPerPodIngress()).orElse(item));
  }
  public ResourceTemplate buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
    _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new ResourceTemplateBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} else { this.persistentVolumeClaim = null; _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim); } return (A) this;
  }
  public boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new PersistentVolumeClaimNested(null);
  }
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
    return new PersistentVolumeClaimNested(item);
  }
  public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(null));
  }
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(item));
  }
  public ContainerTemplate buildKafkaContainer() {
    return this.kafkaContainer!=null ?this.kafkaContainer.build():null;
  }
  public A withKafkaContainer(ContainerTemplate kafkaContainer) {
    _visitables.get("kafkaContainer").remove(this.kafkaContainer);
    if (kafkaContainer!=null){ this.kafkaContainer= new ContainerTemplateBuilder(kafkaContainer); _visitables.get("kafkaContainer").add(this.kafkaContainer);} else { this.kafkaContainer = null; _visitables.get("kafkaContainer").remove(this.kafkaContainer); } return (A) this;
  }
  public boolean hasKafkaContainer() {
    return this.kafkaContainer != null;
  }
  public KafkaContainerNested<A> withNewKafkaContainer() {
    return new KafkaContainerNested(null);
  }
  public KafkaContainerNested<A> withNewKafkaContainerLike(ContainerTemplate item) {
    return new KafkaContainerNested(item);
  }
  public KafkaContainerNested<A> editKafkaContainer() {
    return withNewKafkaContainerLike(java.util.Optional.ofNullable(buildKafkaContainer()).orElse(null));
  }
  public KafkaContainerNested<A> editOrNewKafkaContainer() {
    return withNewKafkaContainerLike(java.util.Optional.ofNullable(buildKafkaContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public KafkaContainerNested<A> editOrNewKafkaContainerLike(ContainerTemplate item) {
    return withNewKafkaContainerLike(java.util.Optional.ofNullable(buildKafkaContainer()).orElse(item));
  }
  public ContainerTemplate buildInitContainer() {
    return this.initContainer!=null ?this.initContainer.build():null;
  }
  public A withInitContainer(ContainerTemplate initContainer) {
    _visitables.get("initContainer").remove(this.initContainer);
    if (initContainer!=null){ this.initContainer= new ContainerTemplateBuilder(initContainer); _visitables.get("initContainer").add(this.initContainer);} else { this.initContainer = null; _visitables.get("initContainer").remove(this.initContainer); } return (A) this;
  }
  public boolean hasInitContainer() {
    return this.initContainer != null;
  }
  public InitContainerNested<A> withNewInitContainer() {
    return new InitContainerNested(null);
  }
  public InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item) {
    return new InitContainerNested(item);
  }
  public InitContainerNested<A> editInitContainer() {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(null));
  }
  public InitContainerNested<A> editOrNewInitContainer() {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item) {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaNodePoolTemplateFluent that = (KafkaNodePoolTemplateFluent) o;
    if (!java.util.Objects.equals(podSet, that.podSet)) return false;

    if (!java.util.Objects.equals(pod, that.pod)) return false;

    if (!java.util.Objects.equals(perPodService, that.perPodService)) return false;

    if (!java.util.Objects.equals(perPodRoute, that.perPodRoute)) return false;

    if (!java.util.Objects.equals(perPodIngress, that.perPodIngress)) return false;

    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;

    if (!java.util.Objects.equals(kafkaContainer, that.kafkaContainer)) return false;

    if (!java.util.Objects.equals(initContainer, that.initContainer)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(podSet,  pod,  perPodService,  perPodRoute,  perPodIngress,  persistentVolumeClaim,  kafkaContainer,  initContainer,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (podSet != null) { sb.append("podSet:"); sb.append(podSet + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (perPodService != null) { sb.append("perPodService:"); sb.append(perPodService + ","); }
    if (perPodRoute != null) { sb.append("perPodRoute:"); sb.append(perPodRoute + ","); }
    if (perPodIngress != null) { sb.append("perPodIngress:"); sb.append(perPodIngress + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (kafkaContainer != null) { sb.append("kafkaContainer:"); sb.append(kafkaContainer + ","); }
    if (initContainer != null) { sb.append("initContainer:"); sb.append(initContainer); }
    sb.append("}");
    return sb.toString();
  }
  public class PodSetNested<N> extends ResourceTemplateFluent<PodSetNested<N>> implements Nested<N>{
    PodSetNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withPodSet(builder.build());
    }
    public N endPodSet() {
      return and();
    }
    
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withPod(builder.build());
    }
    public N endPod() {
      return and();
    }
    
  }
  public class PerPodServiceNested<N> extends ResourceTemplateFluent<PerPodServiceNested<N>> implements Nested<N>{
    PerPodServiceNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withPerPodService(builder.build());
    }
    public N endPerPodService() {
      return and();
    }
    
  }
  public class PerPodRouteNested<N> extends ResourceTemplateFluent<PerPodRouteNested<N>> implements Nested<N>{
    PerPodRouteNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withPerPodRoute(builder.build());
    }
    public N endPerPodRoute() {
      return and();
    }
    
  }
  public class PerPodIngressNested<N> extends ResourceTemplateFluent<PerPodIngressNested<N>> implements Nested<N>{
    PerPodIngressNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withPerPodIngress(builder.build());
    }
    public N endPerPodIngress() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimNested<N> extends ResourceTemplateFluent<PersistentVolumeClaimNested<N>> implements Nested<N>{
    PersistentVolumeClaimNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withPersistentVolumeClaim(builder.build());
    }
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  }
  public class KafkaContainerNested<N> extends ContainerTemplateFluent<KafkaContainerNested<N>> implements Nested<N>{
    KafkaContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withKafkaContainer(builder.build());
    }
    public N endKafkaContainer() {
      return and();
    }
    
  }
  public class InitContainerNested<N> extends ContainerTemplateFluent<InitContainerNested<N>> implements Nested<N>{
    InitContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolTemplateFluent.this.withInitContainer(builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  
}