package io.strimzi.api.kafka.model.podset;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StrimziPodSetSpecBuilder extends StrimziPodSetSpecFluent<StrimziPodSetSpecBuilder> implements VisitableBuilder<StrimziPodSetSpec,StrimziPodSetSpecBuilder>{
  public StrimziPodSetSpecBuilder() {
    this(false);
  }
  public StrimziPodSetSpecBuilder(Boolean validationEnabled) {
    this(new StrimziPodSetSpec(), validationEnabled);
  }
  public StrimziPodSetSpecBuilder(StrimziPodSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StrimziPodSetSpecBuilder(StrimziPodSetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StrimziPodSetSpec(), validationEnabled);
  }
  public StrimziPodSetSpecBuilder(StrimziPodSetSpecFluent<?> fluent,StrimziPodSetSpec instance) {
    this(fluent, instance, false);
  }
  public StrimziPodSetSpecBuilder(StrimziPodSetSpecFluent<?> fluent,StrimziPodSetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StrimziPodSetSpec());

    if (instance != null) {
      fluent.withSelector(instance.getSelector());
      fluent.withPods(instance.getPods());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StrimziPodSetSpecBuilder(StrimziPodSetSpec instance) {
    this(instance,false);
  }
  public StrimziPodSetSpecBuilder(StrimziPodSetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StrimziPodSetSpec());

    if (instance != null) {
      this.withSelector(instance.getSelector());
      this.withPods(instance.getPods());
    }
    this.validationEnabled = validationEnabled; 
  }
  StrimziPodSetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StrimziPodSetSpec build() {
    StrimziPodSetSpec buildable = new StrimziPodSetSpec();
    buildable.setSelector(fluent.getSelector());
    buildable.setPods(fluent.getPods());
    return buildable;
  }
  
}