package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaRebalanceSpecBuilder extends KafkaRebalanceSpecFluent<KafkaRebalanceSpecBuilder> implements VisitableBuilder<KafkaRebalanceSpec,KafkaRebalanceSpecBuilder>{
  public KafkaRebalanceSpecBuilder() {
    this(false);
  }
  public KafkaRebalanceSpecBuilder(Boolean validationEnabled) {
    this(new KafkaRebalanceSpec(), validationEnabled);
  }
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaRebalanceSpec(), validationEnabled);
  }
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent,KafkaRebalanceSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent,KafkaRebalanceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaRebalanceSpec());

    if (instance != null) {
      fluent.withMode(instance.getMode());
      fluent.withBrokers(instance.getBrokers());
      fluent.withGoals(instance.getGoals());
      fluent.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
      fluent.withRebalanceDisk(instance.isRebalanceDisk());
      fluent.withExcludedTopics(instance.getExcludedTopics());
      fluent.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
      fluent.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
      fluent.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
      fluent.withReplicationThrottle(instance.getReplicationThrottle());
      fluent.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpec instance) {
    this(instance,false);
  }
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaRebalanceSpec());

    if (instance != null) {
      this.withMode(instance.getMode());
      this.withBrokers(instance.getBrokers());
      this.withGoals(instance.getGoals());
      this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
      this.withRebalanceDisk(instance.isRebalanceDisk());
      this.withExcludedTopics(instance.getExcludedTopics());
      this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
      this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
      this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
      this.withReplicationThrottle(instance.getReplicationThrottle());
      this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaRebalanceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaRebalanceSpec build() {
    KafkaRebalanceSpec buildable = new KafkaRebalanceSpec();
    buildable.setMode(fluent.getMode());
    buildable.setBrokers(fluent.getBrokers());
    buildable.setGoals(fluent.getGoals());
    buildable.setSkipHardGoalCheck(fluent.isSkipHardGoalCheck());
    buildable.setRebalanceDisk(fluent.isRebalanceDisk());
    buildable.setExcludedTopics(fluent.getExcludedTopics());
    buildable.setConcurrentPartitionMovementsPerBroker(fluent.getConcurrentPartitionMovementsPerBroker());
    buildable.setConcurrentIntraBrokerPartitionMovements(fluent.getConcurrentIntraBrokerPartitionMovements());
    buildable.setConcurrentLeaderMovements(fluent.getConcurrentLeaderMovements());
    buildable.setReplicationThrottle(fluent.getReplicationThrottle());
    buildable.setReplicaMovementStrategies(fluent.getReplicaMovementStrategies());
    return buildable;
  }
  
}