package io.strimzi.api.kafka.model.rebalance;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import io.strimzi.api.kafka.model.common.SpecFluent;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaRebalanceSpecFluent<A extends KafkaRebalanceSpecFluent<A>> extends SpecFluent<A>{
  public KafkaRebalanceSpecFluent() {
  }
  public KafkaRebalanceSpecFluent(KafkaRebalanceSpec instance) {
    instance = (instance != null ? instance : new KafkaRebalanceSpec());

    if (instance != null) {
      this.withMode(instance.getMode());
      this.withBrokers(instance.getBrokers());
      this.withGoals(instance.getGoals());
      this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
      this.withRebalanceDisk(instance.isRebalanceDisk());
      this.withExcludedTopics(instance.getExcludedTopics());
      this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
      this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
      this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
      this.withReplicationThrottle(instance.getReplicationThrottle());
      this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
    }
  }
  private KafkaRebalanceMode mode;
  private List<Integer> brokers;
  private List<String> goals;
  private boolean skipHardGoalCheck;
  private boolean rebalanceDisk;
  private String excludedTopics;
  private int concurrentPartitionMovementsPerBroker;
  private int concurrentIntraBrokerPartitionMovements;
  private int concurrentLeaderMovements;
  private long replicationThrottle;
  private List<String> replicaMovementStrategies;
  public KafkaRebalanceMode getMode() {
    return this.mode;
  }
  public A withMode(KafkaRebalanceMode mode) {
    this.mode=mode; return (A) this;
  }
  public boolean hasMode() {
    return this.mode != null;
  }
  public A addToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.add(index, item);
    return (A)this;
  }
  public A setToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.set(index, item); return (A)this;
  }
  public A addToBrokers(java.lang.Integer... items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  public A addAllToBrokers(Collection<Integer> items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  public A removeFromBrokers(java.lang.Integer... items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  public A removeAllFromBrokers(Collection<Integer> items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  public List<Integer> getBrokers() {
    return this.brokers;
  }
  public Integer getBroker(int index) {
    return this.brokers.get(index);
  }
  public Integer getFirstBroker() {
    return this.brokers.get(0);
  }
  public Integer getLastBroker() {
    return this.brokers.get(brokers.size() - 1);
  }
  public Integer getMatchingBroker(Predicate<Integer> predicate) {
    for (Integer item: brokers) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingBroker(Predicate<Integer> predicate) {
    for (Integer item: brokers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBrokers(List<Integer> brokers) {
    if (brokers != null) {this.brokers = new ArrayList(); for (Integer item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
  }
  public A withBrokers(java.lang.Integer... brokers) {
    if (this.brokers != null) {this.brokers.clear(); _visitables.remove("brokers"); }
    if (brokers != null) {for (Integer item :brokers){ this.addToBrokers(item);}} return (A) this;
  }
  public boolean hasBrokers() {
    return brokers != null && !brokers.isEmpty();
  }
  public A addToGoals(int index,String item) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    this.goals.add(index, item);
    return (A)this;
  }
  public A setToGoals(int index,String item) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    this.goals.set(index, item); return (A)this;
  }
  public A addToGoals(java.lang.String... items) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    for (String item : items) {this.goals.add(item);} return (A)this;
  }
  public A addAllToGoals(Collection<String> items) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    for (String item : items) {this.goals.add(item);} return (A)this;
  }
  public A removeFromGoals(java.lang.String... items) {
    if (this.goals == null) return (A)this;
    for (String item : items) { this.goals.remove(item);} return (A)this;
  }
  public A removeAllFromGoals(Collection<String> items) {
    if (this.goals == null) return (A)this;
    for (String item : items) { this.goals.remove(item);} return (A)this;
  }
  public List<String> getGoals() {
    return this.goals;
  }
  public String getGoal(int index) {
    return this.goals.get(index);
  }
  public String getFirstGoal() {
    return this.goals.get(0);
  }
  public String getLastGoal() {
    return this.goals.get(goals.size() - 1);
  }
  public String getMatchingGoal(Predicate<String> predicate) {
    for (String item: goals) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingGoal(Predicate<String> predicate) {
    for (String item: goals) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGoals(List<String> goals) {
    if (goals != null) {this.goals = new ArrayList(); for (String item : goals){this.addToGoals(item);}} else { this.goals = null;} return (A) this;
  }
  public A withGoals(java.lang.String... goals) {
    if (this.goals != null) {this.goals.clear(); _visitables.remove("goals"); }
    if (goals != null) {for (String item :goals){ this.addToGoals(item);}} return (A) this;
  }
  public boolean hasGoals() {
    return goals != null && !goals.isEmpty();
  }
  public boolean isSkipHardGoalCheck() {
    return this.skipHardGoalCheck;
  }
  public A withSkipHardGoalCheck(boolean skipHardGoalCheck) {
    this.skipHardGoalCheck=skipHardGoalCheck; return (A) this;
  }
  public boolean hasSkipHardGoalCheck() {
    return true;
  }
  public boolean isRebalanceDisk() {
    return this.rebalanceDisk;
  }
  public A withRebalanceDisk(boolean rebalanceDisk) {
    this.rebalanceDisk=rebalanceDisk; return (A) this;
  }
  public boolean hasRebalanceDisk() {
    return true;
  }
  public String getExcludedTopics() {
    return this.excludedTopics;
  }
  public A withExcludedTopics(String excludedTopics) {
    this.excludedTopics=excludedTopics; return (A) this;
  }
  public boolean hasExcludedTopics() {
    return this.excludedTopics != null;
  }
  public int getConcurrentPartitionMovementsPerBroker() {
    return this.concurrentPartitionMovementsPerBroker;
  }
  public A withConcurrentPartitionMovementsPerBroker(int concurrentPartitionMovementsPerBroker) {
    this.concurrentPartitionMovementsPerBroker=concurrentPartitionMovementsPerBroker; return (A) this;
  }
  public boolean hasConcurrentPartitionMovementsPerBroker() {
    return true;
  }
  public int getConcurrentIntraBrokerPartitionMovements() {
    return this.concurrentIntraBrokerPartitionMovements;
  }
  public A withConcurrentIntraBrokerPartitionMovements(int concurrentIntraBrokerPartitionMovements) {
    this.concurrentIntraBrokerPartitionMovements=concurrentIntraBrokerPartitionMovements; return (A) this;
  }
  public boolean hasConcurrentIntraBrokerPartitionMovements() {
    return true;
  }
  public int getConcurrentLeaderMovements() {
    return this.concurrentLeaderMovements;
  }
  public A withConcurrentLeaderMovements(int concurrentLeaderMovements) {
    this.concurrentLeaderMovements=concurrentLeaderMovements; return (A) this;
  }
  public boolean hasConcurrentLeaderMovements() {
    return true;
  }
  public long getReplicationThrottle() {
    return this.replicationThrottle;
  }
  public A withReplicationThrottle(long replicationThrottle) {
    this.replicationThrottle=replicationThrottle; return (A) this;
  }
  public boolean hasReplicationThrottle() {
    return true;
  }
  public A addToReplicaMovementStrategies(int index,String item) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    this.replicaMovementStrategies.add(index, item);
    return (A)this;
  }
  public A setToReplicaMovementStrategies(int index,String item) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    this.replicaMovementStrategies.set(index, item); return (A)this;
  }
  public A addToReplicaMovementStrategies(java.lang.String... items) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    for (String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
  }
  public A addAllToReplicaMovementStrategies(Collection<String> items) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    for (String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
  }
  public A removeFromReplicaMovementStrategies(java.lang.String... items) {
    if (this.replicaMovementStrategies == null) return (A)this;
    for (String item : items) { this.replicaMovementStrategies.remove(item);} return (A)this;
  }
  public A removeAllFromReplicaMovementStrategies(Collection<String> items) {
    if (this.replicaMovementStrategies == null) return (A)this;
    for (String item : items) { this.replicaMovementStrategies.remove(item);} return (A)this;
  }
  public List<String> getReplicaMovementStrategies() {
    return this.replicaMovementStrategies;
  }
  public String getReplicaMovementStrategy(int index) {
    return this.replicaMovementStrategies.get(index);
  }
  public String getFirstReplicaMovementStrategy() {
    return this.replicaMovementStrategies.get(0);
  }
  public String getLastReplicaMovementStrategy() {
    return this.replicaMovementStrategies.get(replicaMovementStrategies.size() - 1);
  }
  public String getMatchingReplicaMovementStrategy(Predicate<String> predicate) {
    for (String item: replicaMovementStrategies) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingReplicaMovementStrategy(Predicate<String> predicate) {
    for (String item: replicaMovementStrategies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReplicaMovementStrategies(List<String> replicaMovementStrategies) {
    if (replicaMovementStrategies != null) {this.replicaMovementStrategies = new ArrayList(); for (String item : replicaMovementStrategies){this.addToReplicaMovementStrategies(item);}} else { this.replicaMovementStrategies = null;} return (A) this;
  }
  public A withReplicaMovementStrategies(java.lang.String... replicaMovementStrategies) {
    if (this.replicaMovementStrategies != null) {this.replicaMovementStrategies.clear(); _visitables.remove("replicaMovementStrategies"); }
    if (replicaMovementStrategies != null) {for (String item :replicaMovementStrategies){ this.addToReplicaMovementStrategies(item);}} return (A) this;
  }
  public boolean hasReplicaMovementStrategies() {
    return replicaMovementStrategies != null && !replicaMovementStrategies.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaRebalanceSpecFluent that = (KafkaRebalanceSpecFluent) o;
    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(brokers, that.brokers)) return false;

    if (!java.util.Objects.equals(goals, that.goals)) return false;

    if (skipHardGoalCheck != that.skipHardGoalCheck) return false;
    if (rebalanceDisk != that.rebalanceDisk) return false;
    if (!java.util.Objects.equals(excludedTopics, that.excludedTopics)) return false;

    if (concurrentPartitionMovementsPerBroker != that.concurrentPartitionMovementsPerBroker) return false;
    if (concurrentIntraBrokerPartitionMovements != that.concurrentIntraBrokerPartitionMovements) return false;
    if (concurrentLeaderMovements != that.concurrentLeaderMovements) return false;
    if (replicationThrottle != that.replicationThrottle) return false;
    if (!java.util.Objects.equals(replicaMovementStrategies, that.replicaMovementStrategies)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(mode,  brokers,  goals,  skipHardGoalCheck,  rebalanceDisk,  excludedTopics,  concurrentPartitionMovementsPerBroker,  concurrentIntraBrokerPartitionMovements,  concurrentLeaderMovements,  replicationThrottle,  replicaMovementStrategies,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (brokers != null && !brokers.isEmpty()) { sb.append("brokers:"); sb.append(brokers + ","); }
    if (goals != null && !goals.isEmpty()) { sb.append("goals:"); sb.append(goals + ","); }
    sb.append("skipHardGoalCheck:"); sb.append(skipHardGoalCheck + ",");
    sb.append("rebalanceDisk:"); sb.append(rebalanceDisk + ",");
    if (excludedTopics != null) { sb.append("excludedTopics:"); sb.append(excludedTopics + ","); }
    sb.append("concurrentPartitionMovementsPerBroker:"); sb.append(concurrentPartitionMovementsPerBroker + ",");
    sb.append("concurrentIntraBrokerPartitionMovements:"); sb.append(concurrentIntraBrokerPartitionMovements + ",");
    sb.append("concurrentLeaderMovements:"); sb.append(concurrentLeaderMovements + ",");
    sb.append("replicationThrottle:"); sb.append(replicationThrottle + ",");
    if (replicaMovementStrategies != null && !replicaMovementStrategies.isEmpty()) { sb.append("replicaMovementStrategies:"); sb.append(replicaMovementStrategies); }
    sb.append("}");
    return sb.toString();
  }
  public A withSkipHardGoalCheck() {
    return withSkipHardGoalCheck(true);
  }
  public A withRebalanceDisk() {
    return withRebalanceDisk(true);
  }
  
}