package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaRebalanceStatusBuilder extends KafkaRebalanceStatusFluent<KafkaRebalanceStatusBuilder> implements VisitableBuilder<KafkaRebalanceStatus,KafkaRebalanceStatusBuilder>{
  public KafkaRebalanceStatusBuilder() {
    this(false);
  }
  public KafkaRebalanceStatusBuilder(Boolean validationEnabled) {
    this(new KafkaRebalanceStatus(), validationEnabled);
  }
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaRebalanceStatus(), validationEnabled);
  }
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent,KafkaRebalanceStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent,KafkaRebalanceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaRebalanceStatus());

    if (instance != null) {
      fluent.withSessionId(instance.getSessionId());
      fluent.withOptimizationResult(instance.getOptimizationResult());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatus instance) {
    this(instance,false);
  }
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaRebalanceStatus());

    if (instance != null) {
      this.withSessionId(instance.getSessionId());
      this.withOptimizationResult(instance.getOptimizationResult());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaRebalanceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaRebalanceStatus build() {
    KafkaRebalanceStatus buildable = new KafkaRebalanceStatus();
    buildable.setSessionId(fluent.getSessionId());
    buildable.setOptimizationResult(fluent.getOptimizationResult());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}