package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaTopicSpecBuilder extends KafkaTopicSpecFluent<KafkaTopicSpecBuilder> implements VisitableBuilder<KafkaTopicSpec,KafkaTopicSpecBuilder>{
  public KafkaTopicSpecBuilder() {
    this(false);
  }
  public KafkaTopicSpecBuilder(Boolean validationEnabled) {
    this(new KafkaTopicSpec(), validationEnabled);
  }
  public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaTopicSpec(), validationEnabled);
  }
  public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent,KafkaTopicSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent,KafkaTopicSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaTopicSpec());

    if (instance != null) {
      fluent.withTopicName(instance.getTopicName());
      fluent.withPartitions(instance.getPartitions());
      fluent.withReplicas(instance.getReplicas());
      fluent.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaTopicSpecBuilder(KafkaTopicSpec instance) {
    this(instance,false);
  }
  public KafkaTopicSpecBuilder(KafkaTopicSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaTopicSpec());

    if (instance != null) {
      this.withTopicName(instance.getTopicName());
      this.withPartitions(instance.getPartitions());
      this.withReplicas(instance.getReplicas());
      this.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaTopicSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaTopicSpec build() {
    KafkaTopicSpec buildable = new KafkaTopicSpec();
    buildable.setTopicName(fluent.getTopicName());
    buildable.setPartitions(fluent.getPartitions());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  
}