package io.strimzi.api.kafka.model.topic;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import java.lang.Object;
import java.lang.String;
import io.strimzi.api.kafka.model.common.SpecFluent;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaTopicSpecFluent<A extends KafkaTopicSpecFluent<A>> extends SpecFluent<A>{
  public KafkaTopicSpecFluent() {
  }
  public KafkaTopicSpecFluent(KafkaTopicSpec instance) {
    instance = (instance != null ? instance : new KafkaTopicSpec());

    if (instance != null) {
      this.withTopicName(instance.getTopicName());
      this.withPartitions(instance.getPartitions());
      this.withReplicas(instance.getReplicas());
      this.withConfig(instance.getConfig());
    }
  }
  private String topicName;
  private Integer partitions;
  private Integer replicas;
  private Map<String,Object> config;
  public String getTopicName() {
    return this.topicName;
  }
  public A withTopicName(String topicName) {
    this.topicName=topicName; return (A) this;
  }
  public boolean hasTopicName() {
    return this.topicName != null;
  }
  public Integer getPartitions() {
    return this.partitions;
  }
  public A withPartitions(Integer partitions) {
    this.partitions=partitions; return (A) this;
  }
  public boolean hasPartitions() {
    return this.partitions != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getConfig() {
    return this.config;
  }
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap(config);} return (A) this;
  }
  public boolean hasConfig() {
    return this.config != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaTopicSpecFluent that = (KafkaTopicSpecFluent) o;
    if (!java.util.Objects.equals(topicName, that.topicName)) return false;

    if (!java.util.Objects.equals(partitions, that.partitions)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(config, that.config)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(topicName,  partitions,  replicas,  config,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (topicName != null) { sb.append("topicName:"); sb.append(topicName + ","); }
    if (partitions != null) { sb.append("partitions:"); sb.append(partitions + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config); }
    sb.append("}");
    return sb.toString();
  }
  
}