package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicasChangeStatusBuilder extends ReplicasChangeStatusFluent<ReplicasChangeStatusBuilder> implements VisitableBuilder<ReplicasChangeStatus,ReplicasChangeStatusBuilder>{
  public ReplicasChangeStatusBuilder() {
    this(false);
  }
  public ReplicasChangeStatusBuilder(Boolean validationEnabled) {
    this(new ReplicasChangeStatus(), validationEnabled);
  }
  public ReplicasChangeStatusBuilder(ReplicasChangeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicasChangeStatusBuilder(ReplicasChangeStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicasChangeStatus(), validationEnabled);
  }
  public ReplicasChangeStatusBuilder(ReplicasChangeStatusFluent<?> fluent,ReplicasChangeStatus instance) {
    this(fluent, instance, false);
  }
  public ReplicasChangeStatusBuilder(ReplicasChangeStatusFluent<?> fluent,ReplicasChangeStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReplicasChangeStatus());

    if (instance != null) {
      fluent.withTargetReplicas(instance.getTargetReplicas());
      fluent.withState(instance.getState());
      fluent.withSessionId(instance.getSessionId());
      fluent.withMessage(instance.getMessage());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReplicasChangeStatusBuilder(ReplicasChangeStatus instance) {
    this(instance,false);
  }
  public ReplicasChangeStatusBuilder(ReplicasChangeStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReplicasChangeStatus());

    if (instance != null) {
      this.withTargetReplicas(instance.getTargetReplicas());
      this.withState(instance.getState());
      this.withSessionId(instance.getSessionId());
      this.withMessage(instance.getMessage());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReplicasChangeStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicasChangeStatus build() {
    ReplicasChangeStatus buildable = new ReplicasChangeStatus();
    buildable.setTargetReplicas(fluent.getTargetReplicas());
    buildable.setState(fluent.getState());
    buildable.setSessionId(fluent.getSessionId());
    buildable.setMessage(fluent.getMessage());
    return buildable;
  }
  
}