package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaUserBuilder extends KafkaUserFluent<KafkaUserBuilder> implements VisitableBuilder<KafkaUser,KafkaUserBuilder>{
  public KafkaUserBuilder() {
    this(false);
  }
  public KafkaUserBuilder(Boolean validationEnabled) {
    this(new KafkaUser(), validationEnabled);
  }
  public KafkaUserBuilder(KafkaUserFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaUserBuilder(KafkaUserFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaUser(), validationEnabled);
  }
  public KafkaUserBuilder(KafkaUserFluent<?> fluent,KafkaUser instance) {
    this(fluent, instance, false);
  }
  public KafkaUserBuilder(KafkaUserFluent<?> fluent,KafkaUser instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaUser());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaUserBuilder(KafkaUser instance) {
    this(instance,false);
  }
  public KafkaUserBuilder(KafkaUser instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaUser());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaUserFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaUser build() {
    KafkaUser buildable = new KafkaUser(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}