package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaUserScramSha512ClientAuthenticationBuilder extends KafkaUserScramSha512ClientAuthenticationFluent<KafkaUserScramSha512ClientAuthenticationBuilder> implements VisitableBuilder<KafkaUserScramSha512ClientAuthentication,KafkaUserScramSha512ClientAuthenticationBuilder>{
  public KafkaUserScramSha512ClientAuthenticationBuilder() {
    this(false);
  }
  public KafkaUserScramSha512ClientAuthenticationBuilder(Boolean validationEnabled) {
    this(new KafkaUserScramSha512ClientAuthentication(), validationEnabled);
  }
  public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaUserScramSha512ClientAuthentication(), validationEnabled);
  }
  public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent,KafkaUserScramSha512ClientAuthentication instance) {
    this(fluent, instance, false);
  }
  public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthenticationFluent<?> fluent,KafkaUserScramSha512ClientAuthentication instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaUserScramSha512ClientAuthentication());

    if (instance != null) {
      fluent.withPassword(instance.getPassword());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthentication instance) {
    this(instance,false);
  }
  public KafkaUserScramSha512ClientAuthenticationBuilder(KafkaUserScramSha512ClientAuthentication instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaUserScramSha512ClientAuthentication());

    if (instance != null) {
      this.withPassword(instance.getPassword());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaUserScramSha512ClientAuthenticationFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaUserScramSha512ClientAuthentication build() {
    KafkaUserScramSha512ClientAuthentication buildable = new KafkaUserScramSha512ClientAuthentication();
    buildable.setPassword(fluent.buildPassword());
    return buildable;
  }
  
}