package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaUserStatusBuilder extends KafkaUserStatusFluent<KafkaUserStatusBuilder> implements VisitableBuilder<KafkaUserStatus,KafkaUserStatusBuilder>{
  public KafkaUserStatusBuilder() {
    this(false);
  }
  public KafkaUserStatusBuilder(Boolean validationEnabled) {
    this(new KafkaUserStatus(), validationEnabled);
  }
  public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaUserStatus(), validationEnabled);
  }
  public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent,KafkaUserStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent,KafkaUserStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaUserStatus());

    if (instance != null) {
      fluent.withUsername(instance.getUsername());
      fluent.withSecret(instance.getSecret());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaUserStatusBuilder(KafkaUserStatus instance) {
    this(instance,false);
  }
  public KafkaUserStatusBuilder(KafkaUserStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaUserStatus());

    if (instance != null) {
      this.withUsername(instance.getUsername());
      this.withSecret(instance.getSecret());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaUserStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaUserStatus build() {
    KafkaUserStatus buildable = new KafkaUserStatus();
    buildable.setUsername(fluent.getUsername());
    buildable.setSecret(fluent.getSecret());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}