package io.strimzi.api.kafka.model.user.acl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AclRuleGroupResourceBuilder extends AclRuleGroupResourceFluent<AclRuleGroupResourceBuilder> implements VisitableBuilder<AclRuleGroupResource,AclRuleGroupResourceBuilder>{
  public AclRuleGroupResourceBuilder() {
    this(false);
  }
  public AclRuleGroupResourceBuilder(Boolean validationEnabled) {
    this(new AclRuleGroupResource(), validationEnabled);
  }
  public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AclRuleGroupResource(), validationEnabled);
  }
  public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent,AclRuleGroupResource instance) {
    this(fluent, instance, false);
  }
  public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent,AclRuleGroupResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AclRuleGroupResource());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withPatternType(instance.getPatternType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AclRuleGroupResourceBuilder(AclRuleGroupResource instance) {
    this(instance,false);
  }
  public AclRuleGroupResourceBuilder(AclRuleGroupResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AclRuleGroupResource());

    if (instance != null) {
      this.withName(instance.getName());
      this.withPatternType(instance.getPatternType());
    }
    this.validationEnabled = validationEnabled; 
  }
  AclRuleGroupResourceFluent<?> fluent;
  Boolean validationEnabled;
  public AclRuleGroupResource build() {
    AclRuleGroupResource buildable = new AclRuleGroupResource();
    buildable.setName(fluent.getName());
    buildable.setPatternType(fluent.getPatternType());
    return buildable;
  }
  
}