package io.strimzi.api.kafka.model.user.acl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AclRuleTopicResourceBuilder extends AclRuleTopicResourceFluent<AclRuleTopicResourceBuilder> implements VisitableBuilder<AclRuleTopicResource,AclRuleTopicResourceBuilder>{
  public AclRuleTopicResourceBuilder() {
    this(false);
  }
  public AclRuleTopicResourceBuilder(Boolean validationEnabled) {
    this(new AclRuleTopicResource(), validationEnabled);
  }
  public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AclRuleTopicResource(), validationEnabled);
  }
  public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent,AclRuleTopicResource instance) {
    this(fluent, instance, false);
  }
  public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent,AclRuleTopicResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AclRuleTopicResource());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withPatternType(instance.getPatternType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AclRuleTopicResourceBuilder(AclRuleTopicResource instance) {
    this(instance,false);
  }
  public AclRuleTopicResourceBuilder(AclRuleTopicResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AclRuleTopicResource());

    if (instance != null) {
      this.withName(instance.getName());
      this.withPatternType(instance.getPatternType());
    }
    this.validationEnabled = validationEnabled; 
  }
  AclRuleTopicResourceFluent<?> fluent;
  Boolean validationEnabled;
  public AclRuleTopicResource build() {
    AclRuleTopicResource buildable = new AclRuleTopicResource();
    buildable.setName(fluent.getName());
    buildable.setPatternType(fluent.getPatternType());
    return buildable;
  }
  
}