package io.strimzi.api.kafka.model.user.acl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AclRuleTransactionalIdResourceBuilder extends AclRuleTransactionalIdResourceFluent<AclRuleTransactionalIdResourceBuilder> implements VisitableBuilder<AclRuleTransactionalIdResource,AclRuleTransactionalIdResourceBuilder>{
  public AclRuleTransactionalIdResourceBuilder() {
    this(false);
  }
  public AclRuleTransactionalIdResourceBuilder(Boolean validationEnabled) {
    this(new AclRuleTransactionalIdResource(), validationEnabled);
  }
  public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AclRuleTransactionalIdResource(), validationEnabled);
  }
  public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent,AclRuleTransactionalIdResource instance) {
    this(fluent, instance, false);
  }
  public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent,AclRuleTransactionalIdResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AclRuleTransactionalIdResource());

    if (instance != null) {
      fluent.withPatternType(instance.getPatternType());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResource instance) {
    this(instance,false);
  }
  public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AclRuleTransactionalIdResource());

    if (instance != null) {
      this.withPatternType(instance.getPatternType());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  AclRuleTransactionalIdResourceFluent<?> fluent;
  Boolean validationEnabled;
  public AclRuleTransactionalIdResource build() {
    AclRuleTransactionalIdResource buildable = new AclRuleTransactionalIdResource();
    buildable.setPatternType(fluent.getPatternType());
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}