package io.strimzi.api.kafka.model.zookeeper;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ZookeeperClusterTemplateBuilder extends ZookeeperClusterTemplateFluent<ZookeeperClusterTemplateBuilder> implements VisitableBuilder<ZookeeperClusterTemplate,ZookeeperClusterTemplateBuilder>{
  public ZookeeperClusterTemplateBuilder() {
    this(false);
  }
  public ZookeeperClusterTemplateBuilder(Boolean validationEnabled) {
    this(new ZookeeperClusterTemplate(), validationEnabled);
  }
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ZookeeperClusterTemplate(), validationEnabled);
  }
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent,ZookeeperClusterTemplate instance) {
    this(fluent, instance, false);
  }
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent,ZookeeperClusterTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ZookeeperClusterTemplate());

    if (instance != null) {
      fluent.withStatefulset(instance.getStatefulset());
      fluent.withPodSet(instance.getPodSet());
      fluent.withPod(instance.getPod());
      fluent.withClientService(instance.getClientService());
      fluent.withNodesService(instance.getNodesService());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      fluent.withZookeeperContainer(instance.getZookeeperContainer());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplate instance) {
    this(instance,false);
  }
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ZookeeperClusterTemplate());

    if (instance != null) {
      this.withStatefulset(instance.getStatefulset());
      this.withPodSet(instance.getPodSet());
      this.withPod(instance.getPod());
      this.withClientService(instance.getClientService());
      this.withNodesService(instance.getNodesService());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withZookeeperContainer(instance.getZookeeperContainer());
      this.withServiceAccount(instance.getServiceAccount());
      this.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  ZookeeperClusterTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public ZookeeperClusterTemplate build() {
    ZookeeperClusterTemplate buildable = new ZookeeperClusterTemplate();
    buildable.setStatefulset(fluent.buildStatefulset());
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setClientService(fluent.buildClientService());
    buildable.setNodesService(fluent.buildNodesService());
    buildable.setPersistentVolumeClaim(fluent.buildPersistentVolumeClaim());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setZookeeperContainer(fluent.buildZookeeperContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  
}