package io.strimzi.api.kafka.model.zookeeper;

import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplate;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ZookeeperClusterTemplateFluent<A extends ZookeeperClusterTemplateFluent<A>> extends BaseFluent<A>{
  public ZookeeperClusterTemplateFluent() {
  }
  public ZookeeperClusterTemplateFluent(ZookeeperClusterTemplate instance) {
    instance = (instance != null ? instance : new ZookeeperClusterTemplate());

    if (instance != null) {
      this.withStatefulset(instance.getStatefulset());
      this.withPodSet(instance.getPodSet());
      this.withPod(instance.getPod());
      this.withClientService(instance.getClientService());
      this.withNodesService(instance.getNodesService());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withZookeeperContainer(instance.getZookeeperContainer());
      this.withServiceAccount(instance.getServiceAccount());
      this.withJmxSecret(instance.getJmxSecret());
    }
  }
  private StatefulSetTemplateBuilder statefulset;
  private ResourceTemplateBuilder podSet;
  private PodTemplateBuilder pod;
  private InternalServiceTemplateBuilder clientService;
  private InternalServiceTemplateBuilder nodesService;
  private ResourceTemplateBuilder persistentVolumeClaim;
  private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
  private ContainerTemplateBuilder zookeeperContainer;
  private ResourceTemplateBuilder serviceAccount;
  private ResourceTemplateBuilder jmxSecret;
  public StatefulSetTemplate buildStatefulset() {
    return this.statefulset!=null ?this.statefulset.build():null;
  }
  public A withStatefulset(StatefulSetTemplate statefulset) {
    _visitables.get("statefulset").remove(this.statefulset);
    if (statefulset!=null){ this.statefulset= new StatefulSetTemplateBuilder(statefulset); _visitables.get("statefulset").add(this.statefulset);} else { this.statefulset = null; _visitables.get("statefulset").remove(this.statefulset); } return (A) this;
  }
  public boolean hasStatefulset() {
    return this.statefulset != null;
  }
  public StatefulsetNested<A> withNewStatefulset() {
    return new StatefulsetNested(null);
  }
  public StatefulsetNested<A> withNewStatefulsetLike(StatefulSetTemplate item) {
    return new StatefulsetNested(item);
  }
  public StatefulsetNested<A> editStatefulset() {
    return withNewStatefulsetLike(java.util.Optional.ofNullable(buildStatefulset()).orElse(null));
  }
  public StatefulsetNested<A> editOrNewStatefulset() {
    return withNewStatefulsetLike(java.util.Optional.ofNullable(buildStatefulset()).orElse(new StatefulSetTemplateBuilder().build()));
  }
  public StatefulsetNested<A> editOrNewStatefulsetLike(StatefulSetTemplate item) {
    return withNewStatefulsetLike(java.util.Optional.ofNullable(buildStatefulset()).orElse(item));
  }
  public ResourceTemplate buildPodSet() {
    return this.podSet!=null ?this.podSet.build():null;
  }
  public A withPodSet(ResourceTemplate podSet) {
    _visitables.get("podSet").remove(this.podSet);
    if (podSet!=null){ this.podSet= new ResourceTemplateBuilder(podSet); _visitables.get("podSet").add(this.podSet);} else { this.podSet = null; _visitables.get("podSet").remove(this.podSet); } return (A) this;
  }
  public boolean hasPodSet() {
    return this.podSet != null;
  }
  public PodSetNested<A> withNewPodSet() {
    return new PodSetNested(null);
  }
  public PodSetNested<A> withNewPodSetLike(ResourceTemplate item) {
    return new PodSetNested(item);
  }
  public PodSetNested<A> editPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(null));
  }
  public PodSetNested<A> editOrNewPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PodSetNested<A> editOrNewPodSetLike(ResourceTemplate item) {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(item));
  }
  public PodTemplate buildPod() {
    return this.pod!=null ?this.pod.build():null;
  }
  public A withPod(PodTemplate pod) {
    _visitables.get("pod").remove(this.pod);
    if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} else { this.pod = null; _visitables.get("pod").remove(this.pod); } return (A) this;
  }
  public boolean hasPod() {
    return this.pod != null;
  }
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  public InternalServiceTemplate buildClientService() {
    return this.clientService!=null ?this.clientService.build():null;
  }
  public A withClientService(InternalServiceTemplate clientService) {
    _visitables.get("clientService").remove(this.clientService);
    if (clientService!=null){ this.clientService= new InternalServiceTemplateBuilder(clientService); _visitables.get("clientService").add(this.clientService);} else { this.clientService = null; _visitables.get("clientService").remove(this.clientService); } return (A) this;
  }
  public boolean hasClientService() {
    return this.clientService != null;
  }
  public ClientServiceNested<A> withNewClientService() {
    return new ClientServiceNested(null);
  }
  public ClientServiceNested<A> withNewClientServiceLike(InternalServiceTemplate item) {
    return new ClientServiceNested(item);
  }
  public ClientServiceNested<A> editClientService() {
    return withNewClientServiceLike(java.util.Optional.ofNullable(buildClientService()).orElse(null));
  }
  public ClientServiceNested<A> editOrNewClientService() {
    return withNewClientServiceLike(java.util.Optional.ofNullable(buildClientService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  public ClientServiceNested<A> editOrNewClientServiceLike(InternalServiceTemplate item) {
    return withNewClientServiceLike(java.util.Optional.ofNullable(buildClientService()).orElse(item));
  }
  public InternalServiceTemplate buildNodesService() {
    return this.nodesService!=null ?this.nodesService.build():null;
  }
  public A withNodesService(InternalServiceTemplate nodesService) {
    _visitables.get("nodesService").remove(this.nodesService);
    if (nodesService!=null){ this.nodesService= new InternalServiceTemplateBuilder(nodesService); _visitables.get("nodesService").add(this.nodesService);} else { this.nodesService = null; _visitables.get("nodesService").remove(this.nodesService); } return (A) this;
  }
  public boolean hasNodesService() {
    return this.nodesService != null;
  }
  public NodesServiceNested<A> withNewNodesService() {
    return new NodesServiceNested(null);
  }
  public NodesServiceNested<A> withNewNodesServiceLike(InternalServiceTemplate item) {
    return new NodesServiceNested(item);
  }
  public NodesServiceNested<A> editNodesService() {
    return withNewNodesServiceLike(java.util.Optional.ofNullable(buildNodesService()).orElse(null));
  }
  public NodesServiceNested<A> editOrNewNodesService() {
    return withNewNodesServiceLike(java.util.Optional.ofNullable(buildNodesService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  public NodesServiceNested<A> editOrNewNodesServiceLike(InternalServiceTemplate item) {
    return withNewNodesServiceLike(java.util.Optional.ofNullable(buildNodesService()).orElse(item));
  }
  public ResourceTemplate buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null ?this.persistentVolumeClaim.build():null;
  }
  public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
    _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new ResourceTemplateBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} else { this.persistentVolumeClaim = null; _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim); } return (A) this;
  }
  public boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new PersistentVolumeClaimNested(null);
  }
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
    return new PersistentVolumeClaimNested(item);
  }
  public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(null));
  }
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(item));
  }
  public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
    return this.podDisruptionBudget!=null ?this.podDisruptionBudget.build():null;
  }
  public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
    _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
    if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} else { this.podDisruptionBudget = null; _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget); } return (A) this;
  }
  public boolean hasPodDisruptionBudget() {
    return this.podDisruptionBudget != null;
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
    return new PodDisruptionBudgetNested(null);
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return new PodDisruptionBudgetNested(item);
  }
  public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(null));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(item));
  }
  public ContainerTemplate buildZookeeperContainer() {
    return this.zookeeperContainer!=null ?this.zookeeperContainer.build():null;
  }
  public A withZookeeperContainer(ContainerTemplate zookeeperContainer) {
    _visitables.get("zookeeperContainer").remove(this.zookeeperContainer);
    if (zookeeperContainer!=null){ this.zookeeperContainer= new ContainerTemplateBuilder(zookeeperContainer); _visitables.get("zookeeperContainer").add(this.zookeeperContainer);} else { this.zookeeperContainer = null; _visitables.get("zookeeperContainer").remove(this.zookeeperContainer); } return (A) this;
  }
  public boolean hasZookeeperContainer() {
    return this.zookeeperContainer != null;
  }
  public ZookeeperContainerNested<A> withNewZookeeperContainer() {
    return new ZookeeperContainerNested(null);
  }
  public ZookeeperContainerNested<A> withNewZookeeperContainerLike(ContainerTemplate item) {
    return new ZookeeperContainerNested(item);
  }
  public ZookeeperContainerNested<A> editZookeeperContainer() {
    return withNewZookeeperContainerLike(java.util.Optional.ofNullable(buildZookeeperContainer()).orElse(null));
  }
  public ZookeeperContainerNested<A> editOrNewZookeeperContainer() {
    return withNewZookeeperContainerLike(java.util.Optional.ofNullable(buildZookeeperContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public ZookeeperContainerNested<A> editOrNewZookeeperContainerLike(ContainerTemplate item) {
    return withNewZookeeperContainerLike(java.util.Optional.ofNullable(buildZookeeperContainer()).orElse(item));
  }
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  public ResourceTemplate buildJmxSecret() {
    return this.jmxSecret!=null ?this.jmxSecret.build():null;
  }
  public A withJmxSecret(ResourceTemplate jmxSecret) {
    _visitables.get("jmxSecret").remove(this.jmxSecret);
    if (jmxSecret!=null){ this.jmxSecret= new ResourceTemplateBuilder(jmxSecret); _visitables.get("jmxSecret").add(this.jmxSecret);} else { this.jmxSecret = null; _visitables.get("jmxSecret").remove(this.jmxSecret); } return (A) this;
  }
  public boolean hasJmxSecret() {
    return this.jmxSecret != null;
  }
  public JmxSecretNested<A> withNewJmxSecret() {
    return new JmxSecretNested(null);
  }
  public JmxSecretNested<A> withNewJmxSecretLike(ResourceTemplate item) {
    return new JmxSecretNested(item);
  }
  public JmxSecretNested<A> editJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(null));
  }
  public JmxSecretNested<A> editOrNewJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(new ResourceTemplateBuilder().build()));
  }
  public JmxSecretNested<A> editOrNewJmxSecretLike(ResourceTemplate item) {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ZookeeperClusterTemplateFluent that = (ZookeeperClusterTemplateFluent) o;
    if (!java.util.Objects.equals(statefulset, that.statefulset)) return false;

    if (!java.util.Objects.equals(podSet, that.podSet)) return false;

    if (!java.util.Objects.equals(pod, that.pod)) return false;

    if (!java.util.Objects.equals(clientService, that.clientService)) return false;

    if (!java.util.Objects.equals(nodesService, that.nodesService)) return false;

    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;

    if (!java.util.Objects.equals(podDisruptionBudget, that.podDisruptionBudget)) return false;

    if (!java.util.Objects.equals(zookeeperContainer, that.zookeeperContainer)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    if (!java.util.Objects.equals(jmxSecret, that.jmxSecret)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(statefulset,  podSet,  pod,  clientService,  nodesService,  persistentVolumeClaim,  podDisruptionBudget,  zookeeperContainer,  serviceAccount,  jmxSecret,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (statefulset != null) { sb.append("statefulset:"); sb.append(statefulset + ","); }
    if (podSet != null) { sb.append("podSet:"); sb.append(podSet + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (clientService != null) { sb.append("clientService:"); sb.append(clientService + ","); }
    if (nodesService != null) { sb.append("nodesService:"); sb.append(nodesService + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (podDisruptionBudget != null) { sb.append("podDisruptionBudget:"); sb.append(podDisruptionBudget + ","); }
    if (zookeeperContainer != null) { sb.append("zookeeperContainer:"); sb.append(zookeeperContainer + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (jmxSecret != null) { sb.append("jmxSecret:"); sb.append(jmxSecret); }
    sb.append("}");
    return sb.toString();
  }
  public class StatefulsetNested<N> extends StatefulSetTemplateFluent<StatefulsetNested<N>> implements Nested<N>{
    StatefulsetNested(StatefulSetTemplate item) {
      this.builder = new StatefulSetTemplateBuilder(this, item);
    }
    StatefulSetTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withStatefulset(builder.build());
    }
    public N endStatefulset() {
      return and();
    }
    
  }
  public class PodSetNested<N> extends ResourceTemplateFluent<PodSetNested<N>> implements Nested<N>{
    PodSetNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withPodSet(builder.build());
    }
    public N endPodSet() {
      return and();
    }
    
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withPod(builder.build());
    }
    public N endPod() {
      return and();
    }
    
  }
  public class ClientServiceNested<N> extends InternalServiceTemplateFluent<ClientServiceNested<N>> implements Nested<N>{
    ClientServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withClientService(builder.build());
    }
    public N endClientService() {
      return and();
    }
    
  }
  public class NodesServiceNested<N> extends InternalServiceTemplateFluent<NodesServiceNested<N>> implements Nested<N>{
    NodesServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withNodesService(builder.build());
    }
    public N endNodesService() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimNested<N> extends ResourceTemplateFluent<PersistentVolumeClaimNested<N>> implements Nested<N>{
    PersistentVolumeClaimNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withPersistentVolumeClaim(builder.build());
    }
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  }
  public class PodDisruptionBudgetNested<N> extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>> implements Nested<N>{
    PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
      this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
    }
    PodDisruptionBudgetTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget() {
      return and();
    }
    
  }
  public class ZookeeperContainerNested<N> extends ContainerTemplateFluent<ZookeeperContainerNested<N>> implements Nested<N>{
    ZookeeperContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withZookeeperContainer(builder.build());
    }
    public N endZookeeperContainer() {
      return and();
    }
    
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  public class JmxSecretNested<N> extends ResourceTemplateFluent<JmxSecretNested<N>> implements Nested<N>{
    JmxSecretNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterTemplateFluent.this.withJmxSecret(builder.build());
    }
    public N endJmxSecret() {
      return and();
    }
    
  }
  
}