/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeAdminClientSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeAdminClientSpecBuilder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeAdminClientSpecFluent;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeConsumerSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeConsumerSpecBuilder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeConsumerSpecFluent;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeHttpConfig;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeHttpConfigBuilder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeHttpConfigFluent;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeProducerSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeProducerSpecBuilder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeProducerSpecFluent;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeTemplate;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeTemplateBuilder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeTemplateFluent;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.ClientTlsBuilder;
import io.strimzi.api.kafka.model.common.ClientTlsFluent;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.Rack;
import io.strimzi.api.kafka.model.common.RackBuilder;
import io.strimzi.api.kafka.model.common.RackFluent;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Builder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Fluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingBuilder;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracing;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingBuilder;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingFluent;
import io.strimzi.api.kafka.model.common.tracing.Tracing;
import java.util.Objects;
import java.util.Optional;

public class KafkaBridgeSpecFluent<A extends KafkaBridgeSpecFluent<A>>
extends SpecFluent<A> {
    private int replicas;
    private String image;
    private KafkaBridgeHttpConfigBuilder http;
    private String bootstrapServers;
    private ClientTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication, ?> authentication;
    private KafkaBridgeConsumerSpecBuilder consumer;
    private KafkaBridgeProducerSpecBuilder producer;
    private KafkaBridgeAdminClientSpecBuilder adminClient;
    private ResourceRequirements resources;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging, ?> logging;
    private boolean enableMetrics;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private KafkaBridgeTemplateBuilder template;
    private VisitableBuilder<? extends Tracing, ?> tracing;
    private String clientRackInitImage;
    private RackBuilder rack;

    public KafkaBridgeSpecFluent() {
    }

    public KafkaBridgeSpecFluent(KafkaBridgeSpec instance) {
        KafkaBridgeSpec kafkaBridgeSpec = instance = instance != null ? instance : new KafkaBridgeSpec();
        if (instance != null) {
            this.withReplicas(instance.getReplicas());
            this.withImage(instance.getImage());
            this.withHttp(instance.getHttp());
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withTls(instance.getTls());
            this.withAuthentication(instance.getAuthentication());
            this.withConsumer(instance.getConsumer());
            this.withProducer(instance.getProducer());
            this.withAdminClient(instance.getAdminClient());
            this.withResources(instance.getResources());
            this.withJvmOptions(instance.getJvmOptions());
            this.withLogging(instance.getLogging());
            this.withEnableMetrics(instance.getEnableMetrics());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withTemplate(instance.getTemplate());
            this.withTracing(instance.getTracing());
            this.withClientRackInitImage(instance.getClientRackInitImage());
            this.withRack(instance.getRack());
        }
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public KafkaBridgeHttpConfig buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    public A withHttp(KafkaBridgeHttpConfig http) {
        this._visitables.get((Object)"http").remove((Object)this.http);
        if (http != null) {
            this.http = new KafkaBridgeHttpConfigBuilder(http);
            this._visitables.get((Object)"http").add(this.http);
        } else {
            this.http = null;
            this._visitables.get((Object)"http").remove((Object)this.http);
        }
        return (A)((Object)this);
    }

    public boolean hasHttp() {
        return this.http != null;
    }

    public A withNewHttp(int port) {
        return this.withHttp(new KafkaBridgeHttpConfig(port));
    }

    public HttpNested<A> withNewHttp() {
        return new HttpNested(null);
    }

    public HttpNested<A> withNewHttpLike(KafkaBridgeHttpConfig item) {
        return new HttpNested(item);
    }

    public HttpNested<A> editHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(null));
    }

    public HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(new KafkaBridgeHttpConfigBuilder().build()));
    }

    public HttpNested<A> editOrNewHttpLike(KafkaBridgeHttpConfig item) {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(item));
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    public ClientTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(ClientTls tls) {
        this._visitables.get((Object)"tls").remove((Object)this.tls);
        if (tls != null) {
            this.tls = new ClientTlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(ClientTls item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new ClientTlsBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(ClientTls item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication == null) {
            this.authentication = null;
            this._visitables.remove((Object)"authentication");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaBridgeSpecFluent.builder(authentication);
        this._visitables.get((Object)"authentication").clear();
        this._visitables.get((Object)"authentication").add(builder);
        this.authentication = builder;
        return (A)((Object)this);
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512Nested(null);
    }

    public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512Nested(item);
    }

    public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNested(null);
    }

    public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNested(item);
    }

    public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNested(null);
    }

    public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNested(item);
    }

    public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
        return new KafkaClientAuthenticationScramSha256Nested(null);
    }

    public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(KafkaClientAuthenticationScramSha256 item) {
        return new KafkaClientAuthenticationScramSha256Nested(item);
    }

    public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNested(null);
    }

    public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNested(item);
    }

    public KafkaBridgeConsumerSpec buildConsumer() {
        return this.consumer != null ? this.consumer.build() : null;
    }

    public A withConsumer(KafkaBridgeConsumerSpec consumer) {
        this._visitables.get((Object)"consumer").remove((Object)this.consumer);
        if (consumer != null) {
            this.consumer = new KafkaBridgeConsumerSpecBuilder(consumer);
            this._visitables.get((Object)"consumer").add(this.consumer);
        } else {
            this.consumer = null;
            this._visitables.get((Object)"consumer").remove((Object)this.consumer);
        }
        return (A)((Object)this);
    }

    public boolean hasConsumer() {
        return this.consumer != null;
    }

    public ConsumerNested<A> withNewConsumer() {
        return new ConsumerNested(null);
    }

    public ConsumerNested<A> withNewConsumerLike(KafkaBridgeConsumerSpec item) {
        return new ConsumerNested(item);
    }

    public ConsumerNested<A> editConsumer() {
        return this.withNewConsumerLike(Optional.ofNullable(this.buildConsumer()).orElse(null));
    }

    public ConsumerNested<A> editOrNewConsumer() {
        return this.withNewConsumerLike(Optional.ofNullable(this.buildConsumer()).orElse(new KafkaBridgeConsumerSpecBuilder().build()));
    }

    public ConsumerNested<A> editOrNewConsumerLike(KafkaBridgeConsumerSpec item) {
        return this.withNewConsumerLike(Optional.ofNullable(this.buildConsumer()).orElse(item));
    }

    public KafkaBridgeProducerSpec buildProducer() {
        return this.producer != null ? this.producer.build() : null;
    }

    public A withProducer(KafkaBridgeProducerSpec producer) {
        this._visitables.get((Object)"producer").remove((Object)this.producer);
        if (producer != null) {
            this.producer = new KafkaBridgeProducerSpecBuilder(producer);
            this._visitables.get((Object)"producer").add(this.producer);
        } else {
            this.producer = null;
            this._visitables.get((Object)"producer").remove((Object)this.producer);
        }
        return (A)((Object)this);
    }

    public boolean hasProducer() {
        return this.producer != null;
    }

    public ProducerNested<A> withNewProducer() {
        return new ProducerNested(null);
    }

    public ProducerNested<A> withNewProducerLike(KafkaBridgeProducerSpec item) {
        return new ProducerNested(item);
    }

    public ProducerNested<A> editProducer() {
        return this.withNewProducerLike(Optional.ofNullable(this.buildProducer()).orElse(null));
    }

    public ProducerNested<A> editOrNewProducer() {
        return this.withNewProducerLike(Optional.ofNullable(this.buildProducer()).orElse(new KafkaBridgeProducerSpecBuilder().build()));
    }

    public ProducerNested<A> editOrNewProducerLike(KafkaBridgeProducerSpec item) {
        return this.withNewProducerLike(Optional.ofNullable(this.buildProducer()).orElse(item));
    }

    public KafkaBridgeAdminClientSpec buildAdminClient() {
        return this.adminClient != null ? this.adminClient.build() : null;
    }

    public A withAdminClient(KafkaBridgeAdminClientSpec adminClient) {
        this._visitables.get((Object)"adminClient").remove((Object)this.adminClient);
        if (adminClient != null) {
            this.adminClient = new KafkaBridgeAdminClientSpecBuilder(adminClient);
            this._visitables.get((Object)"adminClient").add(this.adminClient);
        } else {
            this.adminClient = null;
            this._visitables.get((Object)"adminClient").remove((Object)this.adminClient);
        }
        return (A)((Object)this);
    }

    public boolean hasAdminClient() {
        return this.adminClient != null;
    }

    public AdminClientNested<A> withNewAdminClient() {
        return new AdminClientNested(null);
    }

    public AdminClientNested<A> withNewAdminClientLike(KafkaBridgeAdminClientSpec item) {
        return new AdminClientNested(item);
    }

    public AdminClientNested<A> editAdminClient() {
        return this.withNewAdminClientLike(Optional.ofNullable(this.buildAdminClient()).orElse(null));
    }

    public AdminClientNested<A> editOrNewAdminClient() {
        return this.withNewAdminClientLike(Optional.ofNullable(this.buildAdminClient()).orElse(new KafkaBridgeAdminClientSpecBuilder().build()));
    }

    public AdminClientNested<A> editOrNewAdminClientLike(KafkaBridgeAdminClientSpec item) {
        return this.withNewAdminClientLike(Optional.ofNullable(this.buildAdminClient()).orElse(item));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    public A withLogging(Logging logging) {
        if (logging == null) {
            this.logging = null;
            this._visitables.remove((Object)"logging");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaBridgeSpecFluent.builder(logging);
        this._visitables.get((Object)"logging").clear();
        this._visitables.get((Object)"logging").add(builder);
        this.logging = builder;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNested(null);
    }

    public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNested(item);
    }

    public ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNested(null);
    }

    public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNested(item);
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return (A)((Object)this);
    }

    public boolean hasEnableMetrics() {
        return true;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public KafkaBridgeTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(KafkaBridgeTemplate template) {
        this._visitables.get((Object)"template").remove((Object)this.template);
        if (template != null) {
            this.template = new KafkaBridgeTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(KafkaBridgeTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new KafkaBridgeTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(KafkaBridgeTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public Tracing buildTracing() {
        return this.tracing != null ? (Tracing)this.tracing.build() : null;
    }

    public A withTracing(Tracing tracing) {
        if (tracing == null) {
            this.tracing = null;
            this._visitables.remove((Object)"tracing");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaBridgeSpecFluent.builder(tracing);
        this._visitables.get((Object)"tracing").clear();
        this._visitables.get((Object)"tracing").add(builder);
        this.tracing = builder;
        return (A)((Object)this);
    }

    public boolean hasTracing() {
        return this.tracing != null;
    }

    public JaegerTracingNested<A> withNewJaegerTracing() {
        return new JaegerTracingNested(null);
    }

    public JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item) {
        return new JaegerTracingNested(item);
    }

    public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracing() {
        return new OpenTelemetryTracingNested(null);
    }

    public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracingLike(OpenTelemetryTracing item) {
        return new OpenTelemetryTracingNested(item);
    }

    public String getClientRackInitImage() {
        return this.clientRackInitImage;
    }

    public A withClientRackInitImage(String clientRackInitImage) {
        this.clientRackInitImage = clientRackInitImage;
        return (A)((Object)this);
    }

    public boolean hasClientRackInitImage() {
        return this.clientRackInitImage != null;
    }

    public Rack buildRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    public A withRack(Rack rack) {
        this._visitables.get((Object)"rack").remove((Object)this.rack);
        if (rack != null) {
            this.rack = new RackBuilder(rack);
            this._visitables.get((Object)"rack").add(this.rack);
        } else {
            this.rack = null;
            this._visitables.get((Object)"rack").remove((Object)this.rack);
        }
        return (A)((Object)this);
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public A withNewRack(String topologyKey) {
        return this.withRack(new Rack(topologyKey));
    }

    public RackNested<A> withNewRack() {
        return new RackNested(null);
    }

    public RackNested<A> withNewRackLike(Rack item) {
        return new RackNested(item);
    }

    public RackNested<A> editRack() {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(null));
    }

    public RackNested<A> editOrNewRack() {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(new RackBuilder().build()));
    }

    public RackNested<A> editOrNewRackLike(Rack item) {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBridgeSpecFluent that = (KafkaBridgeSpecFluent)((Object)o);
        if (this.replicas != that.replicas) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals((Object)this.http, (Object)that.http)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals((Object)this.tls, (Object)that.tls)) {
            return false;
        }
        if (!Objects.equals(this.authentication, that.authentication)) {
            return false;
        }
        if (!Objects.equals((Object)this.consumer, (Object)that.consumer)) {
            return false;
        }
        if (!Objects.equals((Object)this.producer, (Object)that.producer)) {
            return false;
        }
        if (!Objects.equals((Object)this.adminClient, (Object)that.adminClient)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (this.enableMetrics != that.enableMetrics) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        if (!Objects.equals(this.tracing, that.tracing)) {
            return false;
        }
        if (!Objects.equals(this.clientRackInitImage, that.clientRackInitImage)) {
            return false;
        }
        return Objects.equals((Object)this.rack, (Object)that.rack);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.replicas, this.image, this.http, this.bootstrapServers, this.tls, this.authentication, this.consumer, this.producer, this.adminClient, this.resources, this.jvmOptions, this.logging, this.enableMetrics, this.livenessProbe, this.readinessProbe, this.template, this.tracing, this.clientRackInitImage, this.rack, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.http != null) {
            sb.append("http:");
            sb.append(this.http + ",");
        }
        if (this.bootstrapServers != null) {
            sb.append("bootstrapServers:");
            sb.append(this.bootstrapServers + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append(this.tls + ",");
        }
        if (this.authentication != null) {
            sb.append("authentication:");
            sb.append(this.authentication + ",");
        }
        if (this.consumer != null) {
            sb.append("consumer:");
            sb.append(this.consumer + ",");
        }
        if (this.producer != null) {
            sb.append("producer:");
            sb.append(this.producer + ",");
        }
        if (this.adminClient != null) {
            sb.append("adminClient:");
            sb.append(this.adminClient + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append(this.jvmOptions + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        sb.append("enableMetrics:");
        sb.append(this.enableMetrics + ",");
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.tracing != null) {
            sb.append("tracing:");
            sb.append(this.tracing + ",");
        }
        if (this.clientRackInitImage != null) {
            sb.append("clientRackInitImage:");
            sb.append(this.clientRackInitImage + ",");
        }
        if (this.rack != null) {
            sb.append("rack:");
            sb.append((Object)this.rack);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512": {
                return new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTls": {
                return new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth": {
                return new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256": {
                return new KafkaClientAuthenticationScramSha256Builder((KafkaClientAuthenticationScramSha256)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlain": {
                return new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)item);
            }
            case "io.strimzi.api.kafka.model.common.InlineLogging": {
                return new InlineLoggingBuilder((InlineLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.ExternalLogging": {
                return new ExternalLoggingBuilder((ExternalLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.tracing.JaegerTracing": {
                return new JaegerTracingBuilder((JaegerTracing)item);
            }
            case "io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracing": {
                return new OpenTelemetryTracingBuilder((OpenTelemetryTracing)item);
            }
        }
        return KafkaBridgeSpecFluent.builderOf((Object)item);
    }

    public A withEnableMetrics() {
        return this.withEnableMetrics(true);
    }

    public class HttpNested<N>
    extends KafkaBridgeHttpConfigFluent<HttpNested<N>>
    implements Nested<N> {
        KafkaBridgeHttpConfigBuilder builder;

        HttpNested(KafkaBridgeHttpConfig item) {
            this.builder = new KafkaBridgeHttpConfigBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withHttp(this.builder.build());
        }

        public N endHttp() {
            return this.and();
        }
    }

    public class TlsNested<N>
    extends ClientTlsFluent<TlsNested<N>>
    implements Nested<N> {
        ClientTlsBuilder builder;

        TlsNested(ClientTls item) {
            this.builder = new ClientTlsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha512Nested<N>
    extends KafkaClientAuthenticationScramSha512Fluent<KafkaClientAuthenticationScramSha512Nested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationScramSha512Builder builder;

        KafkaClientAuthenticationScramSha512Nested(KafkaClientAuthenticationScramSha512 item) {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationScramSha512() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationTlsNested<N>
    extends KafkaClientAuthenticationTlsFluent<KafkaClientAuthenticationTlsNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationTlsBuilder builder;

        KafkaClientAuthenticationTlsNested(KafkaClientAuthenticationTls item) {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationOAuthNested<N>
    extends KafkaClientAuthenticationOAuthFluent<KafkaClientAuthenticationOAuthNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationOAuthBuilder builder;

        KafkaClientAuthenticationOAuthNested(KafkaClientAuthenticationOAuth item) {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationOAuth() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha256Nested<N>
    extends KafkaClientAuthenticationScramSha256Fluent<KafkaClientAuthenticationScramSha256Nested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationScramSha256Builder builder;

        KafkaClientAuthenticationScramSha256Nested(KafkaClientAuthenticationScramSha256 item) {
            this.builder = new KafkaClientAuthenticationScramSha256Builder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationScramSha256() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationPlainNested<N>
    extends KafkaClientAuthenticationPlainFluent<KafkaClientAuthenticationPlainNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationPlainBuilder builder;

        KafkaClientAuthenticationPlainNested(KafkaClientAuthenticationPlain item) {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationPlain() {
            return this.and();
        }
    }

    public class ConsumerNested<N>
    extends KafkaBridgeConsumerSpecFluent<ConsumerNested<N>>
    implements Nested<N> {
        KafkaBridgeConsumerSpecBuilder builder;

        ConsumerNested(KafkaBridgeConsumerSpec item) {
            this.builder = new KafkaBridgeConsumerSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withConsumer(this.builder.build());
        }

        public N endConsumer() {
            return this.and();
        }
    }

    public class ProducerNested<N>
    extends KafkaBridgeProducerSpecFluent<ProducerNested<N>>
    implements Nested<N> {
        KafkaBridgeProducerSpecBuilder builder;

        ProducerNested(KafkaBridgeProducerSpec item) {
            this.builder = new KafkaBridgeProducerSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withProducer(this.builder.build());
        }

        public N endProducer() {
            return this.and();
        }
    }

    public class AdminClientNested<N>
    extends KafkaBridgeAdminClientSpecFluent<AdminClientNested<N>>
    implements Nested<N> {
        KafkaBridgeAdminClientSpecBuilder builder;

        AdminClientNested(KafkaBridgeAdminClientSpec item) {
            this.builder = new KafkaBridgeAdminClientSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withAdminClient(this.builder.build());
        }

        public N endAdminClient() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }

    public class InlineLoggingNested<N>
    extends InlineLoggingFluent<InlineLoggingNested<N>>
    implements Nested<N> {
        InlineLoggingBuilder builder;

        InlineLoggingNested(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withLogging(this.builder.build());
        }

        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNested<N>
    extends ExternalLoggingFluent<ExternalLoggingNested<N>>
    implements Nested<N> {
        ExternalLoggingBuilder builder;

        ExternalLoggingNested(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withLogging(this.builder.build());
        }

        public N endExternalLogging() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends KafkaBridgeTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        KafkaBridgeTemplateBuilder builder;

        TemplateNested(KafkaBridgeTemplate item) {
            this.builder = new KafkaBridgeTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class JaegerTracingNested<N>
    extends JaegerTracingFluent<JaegerTracingNested<N>>
    implements Nested<N> {
        JaegerTracingBuilder builder;

        JaegerTracingNested(JaegerTracing item) {
            this.builder = new JaegerTracingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withTracing(this.builder.build());
        }

        public N endJaegerTracing() {
            return this.and();
        }
    }

    public class OpenTelemetryTracingNested<N>
    extends OpenTelemetryTracingFluent<OpenTelemetryTracingNested<N>>
    implements Nested<N> {
        OpenTelemetryTracingBuilder builder;

        OpenTelemetryTracingNested(OpenTelemetryTracing item) {
            this.builder = new OpenTelemetryTracingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withTracing(this.builder.build());
        }

        public N endOpenTelemetryTracing() {
            return this.and();
        }
    }

    public class RackNested<N>
    extends RackFluent<RackNested<N>>
    implements Nested<N> {
        RackBuilder builder;

        RackNested(Rack item) {
            this.builder = new RackBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeSpecFluent.this.withRack(this.builder.build());
        }

        public N endRack() {
            return this.and();
        }
    }
}

