/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"initialDelaySeconds", "timeoutSeconds", "periodSeconds", "successThreshold", "failureThreshold"})
public class Probe
implements UnknownPropertyPreserving {
    private int initialDelaySeconds = 15;
    private int timeoutSeconds = 5;
    private Integer periodSeconds;
    private Integer successThreshold;
    private Integer failureThreshold;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    public Probe() {
    }

    public Probe(int initialDelaySeconds, int timeoutSeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Description(value="The initial delay before first the health is first checked. Default to 15 seconds. Minimum value is 0.")
    @Minimum(value=0)
    @JsonProperty(defaultValue="15")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public void setInitialDelaySeconds(int initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
    }

    @Description(value="The timeout for each attempted health check. Default to 5 seconds. Minimum value is 1.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="5")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @Description(value="How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="10")
    public Integer getPeriodSeconds() {
        return this.periodSeconds;
    }

    public void setPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
    }

    @Description(value="Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="1")
    public Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public void setSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
    }

    @Description(value="Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="3")
    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public void setFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Probe)) {
            return false;
        }
        Probe other = (Probe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialDelaySeconds() != other.getInitialDelaySeconds()) {
            return false;
        }
        if (this.getTimeoutSeconds() != other.getTimeoutSeconds()) {
            return false;
        }
        Integer this$periodSeconds = this.getPeriodSeconds();
        Integer other$periodSeconds = other.getPeriodSeconds();
        if (this$periodSeconds == null ? other$periodSeconds != null : !((Object)this$periodSeconds).equals(other$periodSeconds)) {
            return false;
        }
        Integer this$successThreshold = this.getSuccessThreshold();
        Integer other$successThreshold = other.getSuccessThreshold();
        if (this$successThreshold == null ? other$successThreshold != null : !((Object)this$successThreshold).equals(other$successThreshold)) {
            return false;
        }
        Integer this$failureThreshold = this.getFailureThreshold();
        Integer other$failureThreshold = other.getFailureThreshold();
        if (this$failureThreshold == null ? other$failureThreshold != null : !((Object)this$failureThreshold).equals(other$failureThreshold)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Probe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialDelaySeconds();
        result = result * 59 + this.getTimeoutSeconds();
        Integer $periodSeconds = this.getPeriodSeconds();
        result = result * 59 + ($periodSeconds == null ? 43 : ((Object)$periodSeconds).hashCode());
        Integer $successThreshold = this.getSuccessThreshold();
        result = result * 59 + ($successThreshold == null ? 43 : ((Object)$successThreshold).hashCode());
        Integer $failureThreshold = this.getFailureThreshold();
        result = result * 59 + ($failureThreshold == null ? 43 : ((Object)$failureThreshold).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "Probe(initialDelaySeconds=" + this.getInitialDelaySeconds() + ", timeoutSeconds=" + this.getTimeoutSeconds() + ", periodSeconds=" + this.getPeriodSeconds() + ", successThreshold=" + this.getSuccessThreshold() + ", failureThreshold=" + this.getFailureThreshold() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

