/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.BuildConfigTemplate;
import io.strimzi.api.kafka.model.common.template.MetadataTemplate;
import io.strimzi.api.kafka.model.common.template.MetadataTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.MetadataTemplateFluent;
import java.util.Objects;
import java.util.Optional;

public class BuildConfigTemplateFluent<A extends BuildConfigTemplateFluent<A>>
extends BaseFluent<A> {
    private MetadataTemplateBuilder metadata;
    private String pullSecret;

    public BuildConfigTemplateFluent() {
    }

    public BuildConfigTemplateFluent(BuildConfigTemplate instance) {
        BuildConfigTemplate buildConfigTemplate = instance = instance != null ? instance : new BuildConfigTemplate();
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withPullSecret(instance.getPullSecret());
        }
    }

    public MetadataTemplate buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(MetadataTemplate metadata) {
        this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        if (metadata != null) {
            this.metadata = new MetadataTemplateBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new MetadataTemplateBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getPullSecret() {
        return this.pullSecret;
    }

    public A withPullSecret(String pullSecret) {
        this.pullSecret = pullSecret;
        return (A)((Object)this);
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigTemplateFluent that = (BuildConfigTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.metadata, (Object)that.metadata)) {
            return false;
        }
        return Objects.equals(this.pullSecret, that.pullSecret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.pullSecret, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends MetadataTemplateFluent<MetadataNested<N>>
    implements Nested<N> {
        MetadataTemplateBuilder builder;

        MetadataNested(MetadataTemplate item) {
            this.builder = new MetadataTemplateBuilder(this, item);
        }

        public N and() {
            return (N)BuildConfigTemplateFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

