/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.connect.KafkaConnect;
import io.strimzi.api.kafka.model.connect.KafkaConnectSpec;
import io.strimzi.api.kafka.model.connect.KafkaConnectSpecBuilder;
import io.strimzi.api.kafka.model.connect.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.connect.KafkaConnectStatus;
import io.strimzi.api.kafka.model.connect.KafkaConnectStatusBuilder;
import io.strimzi.api.kafka.model.connect.KafkaConnectStatusFluent;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2Status;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2StatusBuilder;
import java.util.Objects;
import java.util.Optional;

public class KafkaConnectFluent<A extends KafkaConnectFluent<A>>
extends CustomResourceFluent<KafkaConnectSpec, KafkaConnectStatus, A> {
    private String apiVersion;
    private String kind;
    private KafkaConnectSpecBuilder spec;
    private KafkaConnectStatusBuilder status;

    public KafkaConnectFluent() {
    }

    public KafkaConnectFluent(KafkaConnect instance) {
        KafkaConnect kafkaConnect = instance = instance != null ? instance : new KafkaConnect();
        if (instance != null) {
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public KafkaConnectSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(KafkaConnectSpec spec) {
        this._visitables.get((Object)"spec").remove((Object)this.spec);
        if (spec != null) {
            this.spec = new KafkaConnectSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(KafkaConnectSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new KafkaConnectSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(KafkaConnectSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public KafkaConnectStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(KafkaConnectStatus status) {
        this._visitables.get((Object)"status").remove((Object)this.status);
        if (status != null) {
            this.status = new KafkaConnectStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(KafkaConnectStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new KafkaConnectStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(KafkaConnectStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectFluent that = (KafkaConnectFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.kind, this.spec, this.status, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append((Object)this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2Status": {
                return new KafkaMirrorMaker2StatusBuilder((KafkaMirrorMaker2Status)item);
            }
        }
        return KafkaConnectFluent.builderOf((Object)item);
    }

    public class SpecNested<N>
    extends KafkaConnectSpecFluent<SpecNested<N>>
    implements Nested<N> {
        KafkaConnectSpecBuilder builder;

        SpecNested(KafkaConnectSpec item) {
            this.builder = new KafkaConnectSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends KafkaConnectStatusFluent<StatusNested<N>>
    implements Nested<N> {
        KafkaConnectStatusBuilder builder;

        StatusNested(KafkaConnectStatus item) {
            this.builder = new KafkaConnectStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

