/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.connect.build.DockerOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DockerOutputFluent<A extends DockerOutputFluent<A>>
extends BaseFluent<A> {
    private String pushSecret;
    private List<String> additionalKanikoOptions;
    private String image;

    public DockerOutputFluent() {
    }

    public DockerOutputFluent(DockerOutput instance) {
        DockerOutput dockerOutput = instance = instance != null ? instance : new DockerOutput();
        if (instance != null) {
            this.withPushSecret(instance.getPushSecret());
            this.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
            this.withImage(instance.getImage());
        }
    }

    public String getPushSecret() {
        return this.pushSecret;
    }

    public A withPushSecret(String pushSecret) {
        this.pushSecret = pushSecret;
        return (A)((Object)this);
    }

    public boolean hasPushSecret() {
        return this.pushSecret != null;
    }

    public A addToAdditionalKanikoOptions(int index, String item) {
        if (this.additionalKanikoOptions == null) {
            this.additionalKanikoOptions = new ArrayList<String>();
        }
        this.additionalKanikoOptions.add(index, item);
        return (A)((Object)this);
    }

    public A setToAdditionalKanikoOptions(int index, String item) {
        if (this.additionalKanikoOptions == null) {
            this.additionalKanikoOptions = new ArrayList<String>();
        }
        this.additionalKanikoOptions.set(index, item);
        return (A)((Object)this);
    }

    public A addToAdditionalKanikoOptions(String ... items) {
        if (this.additionalKanikoOptions == null) {
            this.additionalKanikoOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalKanikoOptions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalKanikoOptions(Collection<String> items) {
        if (this.additionalKanikoOptions == null) {
            this.additionalKanikoOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalKanikoOptions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalKanikoOptions(String ... items) {
        if (this.additionalKanikoOptions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalKanikoOptions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalKanikoOptions(Collection<String> items) {
        if (this.additionalKanikoOptions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalKanikoOptions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAdditionalKanikoOptions() {
        return this.additionalKanikoOptions;
    }

    public String getAdditionalKanikoOption(int index) {
        return this.additionalKanikoOptions.get(index);
    }

    public String getFirstAdditionalKanikoOption() {
        return this.additionalKanikoOptions.get(0);
    }

    public String getLastAdditionalKanikoOption() {
        return this.additionalKanikoOptions.get(this.additionalKanikoOptions.size() - 1);
    }

    public String getMatchingAdditionalKanikoOption(Predicate<String> predicate) {
        for (String item : this.additionalKanikoOptions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdditionalKanikoOption(Predicate<String> predicate) {
        for (String item : this.additionalKanikoOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalKanikoOptions(List<String> additionalKanikoOptions) {
        if (additionalKanikoOptions != null) {
            this.additionalKanikoOptions = new ArrayList<String>();
            for (String item : additionalKanikoOptions) {
                this.addToAdditionalKanikoOptions(item);
            }
        } else {
            this.additionalKanikoOptions = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalKanikoOptions(String ... additionalKanikoOptions) {
        if (this.additionalKanikoOptions != null) {
            this.additionalKanikoOptions.clear();
            this._visitables.remove((Object)"additionalKanikoOptions");
        }
        if (additionalKanikoOptions != null) {
            for (String item : additionalKanikoOptions) {
                this.addToAdditionalKanikoOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalKanikoOptions() {
        return this.additionalKanikoOptions != null && !this.additionalKanikoOptions.isEmpty();
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerOutputFluent that = (DockerOutputFluent)((Object)o);
        if (!Objects.equals(this.pushSecret, that.pushSecret)) {
            return false;
        }
        if (!Objects.equals(this.additionalKanikoOptions, that.additionalKanikoOptions)) {
            return false;
        }
        return Objects.equals(this.image, that.image);
    }

    public int hashCode() {
        return Objects.hash(this.pushSecret, this.additionalKanikoOptions, this.image, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pushSecret != null) {
            sb.append("pushSecret:");
            sb.append(this.pushSecret + ",");
        }
        if (this.additionalKanikoOptions != null && !this.additionalKanikoOptions.isEmpty()) {
            sb.append("additionalKanikoOptions:");
            sb.append(this.additionalKanikoOptions + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image);
        }
        sb.append("}");
        return sb.toString();
    }
}

