/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.connect.build.DownloadableArtifact;
import java.util.Objects;

public class DownloadableArtifactFluent<A extends DownloadableArtifactFluent<A>>
extends BaseFluent<A> {
    private String url;
    private String sha512sum;
    private Boolean insecure;

    public DownloadableArtifactFluent() {
    }

    public DownloadableArtifactFluent(DownloadableArtifact instance) {
        if (instance != null) {
            this.withUrl(instance.getUrl());
            this.withSha512sum(instance.getSha512sum());
            this.withInsecure(instance.getInsecure());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public String getSha512sum() {
        return this.sha512sum;
    }

    public A withSha512sum(String sha512sum) {
        this.sha512sum = sha512sum;
        return (A)((Object)this);
    }

    public boolean hasSha512sum() {
        return this.sha512sum != null;
    }

    public Boolean getInsecure() {
        return this.insecure;
    }

    public A withInsecure(Boolean insecure) {
        this.insecure = insecure;
        return (A)((Object)this);
    }

    public boolean hasInsecure() {
        return this.insecure != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DownloadableArtifactFluent that = (DownloadableArtifactFluent)((Object)o);
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.sha512sum, that.sha512sum)) {
            return false;
        }
        return Objects.equals(this.insecure, that.insecure);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.sha512sum, this.insecure, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.sha512sum != null) {
            sb.append("sha512sum:");
            sb.append(this.sha512sum + ",");
        }
        if (this.insecure != null) {
            sb.append("insecure:");
            sb.append(this.insecure);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecure() {
        return this.withInsecure(true);
    }
}

